/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.enderturret.minestuckcompat.MinestuckCompat;
import net.enderturret.minestuckcompat.MinestuckCompatConfig;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.conditions.ICondition;

public record ConfigCondition(String option, String modId) implements ICondition
{
    public static final MapCodec<ConfigCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("option", (Object)"").forGetter(ConfigCondition::option), (App)Codec.STRING.optionalFieldOf("modid", (Object)"").forGetter(ConfigCondition::modId)).apply((Applicative)builder, ConfigCondition::new));

    public ConfigCondition(String modId) {
        this("", modId);
    }

    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }

    public boolean test(ICondition.IContext context) {
        ModList ml = ModList.get();
        return switch (this.option) {
            case "" -> {
                if (ml.isLoaded(this.modId) && MinestuckCompatConfig.common().isModEnabled(this.modId)) {
                    yield true;
                }
                yield false;
            }
            case "disableExtraStuckInterpreters" -> {
                if (!ml.isLoaded("extrastuck") || !MinestuckCompatConfig.common().useExtraStuckInterpreters.getAsBoolean()) {
                    yield true;
                }
                yield false;
            }
            default -> {
                MinestuckCompat.LOGGER.warn("Unknown config option: {}", (Object)this.option);
                yield false;
            }
        };
    }

    @Override
    public String toString() {
        return "config(\"" + this.modId + "\")";
    }
}

