/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.alchemy;

import com.mojang.serialization.Codec;
import com.mraof.minestuck.alchemy.recipe.RegularCombinationRecipe;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeGeneratedCostHandler;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeGeneratedGristCost;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.recipe.GristCostRecipe;
import com.mraof.minestuck.api.alchemy.recipe.combination.CombinationMode;
import com.mraof.minestuck.item.crafting.MSRecipeTypes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.enderturret.minestuckcompat.MinestuckCompat;
import net.enderturret.minestuckcompat.MinestuckCompatConfig;
import net.enderturret.minestuckcompat.api.alchemy.RegisterGristCostProvidersEvent;
import net.enderturret.minestuckcompat.mixin.feature.outside_grist_costs.GeneratorProcessAccess;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.GameMasterBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.MapExtendingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class MixinHooks {
    public static final Codec<Optional<RecipeGeneratedCostHandler.SourceEntry>> CONDITIONAL_SOURCE_ENTRY = ConditionalOps.createConditionalCodec((Codec)RecipeGeneratedCostHandler.SourceEntry.CODEC);
    public static final Codec<List<Optional<RecipeGeneratedCostHandler.SourceEntry>>> CONDITIONAL_SOURCE_ENTRY_LIST = CONDITIONAL_SOURCE_ENTRY.listOf();
    public static Map<Item, GristSet.Immutable> generatedCosts;

    public static void generateAdditionalGristCosts(GeneratorProcessAccess access) {
        MinestuckCompat.LOGGER.info("Discovering additional grist cost providers!");
        NeoForge.EVENT_BUS.post((Event)new RegisterGristCostProvidersEvent(generatedCosts, access));
        generatedCosts = null;
    }

    public static void checkItemsWithoutGristCost(RecipeManager recipeManager) {
        if (MinestuckCompatConfig.common().checkConflictingCombinationRecipes.getAsBoolean()) {
            MixinHooks.checkDuplicateCombinations(recipeManager);
        }
        if (!MinestuckCompatConfig.common().dumpGristlessItems.getAsBoolean()) {
            return;
        }
        ArrayList<ResourceLocation> items = new ArrayList<ResourceLocation>();
        TreeMap<ResourceLocation, List<ResourceLocation>> multiSources = new TreeMap<ResourceLocation, List<ResourceLocation>>(ResourceLocation::compareNamespaced);
        Predicate<Item> filter = MixinHooks.getUnobtainableItemPredicate();
        for (Item item : BuiltInRegistries.ITEM) {
            if (filter.test(item)) continue;
            ResourceLocation id = item.builtInRegistryHolder().getKey().location();
            List<RecipeHolder<GristCostRecipe>> recipes = MixinHooks.hasGristCost(item.getDefaultInstance(), recipeManager);
            if (recipes.isEmpty()) {
                items.add(id);
            }
            if (recipes.size() <= 1) continue;
            recipes.removeIf(holder -> holder.value() instanceof RecipeGeneratedGristCost);
            if (recipes.size() <= 1) continue;
            multiSources.put(id, recipes.stream().map(RecipeHolder::id).sorted(ResourceLocation::compareNamespaced).toList());
        }
        if (!items.isEmpty()) {
            items.sort(ResourceLocation::compareNamespaced);
            MinestuckCompat.LOGGER.info("Items without grist costs:\n{}", (Object)items.stream().map(ResourceLocation::toString).collect(Collectors.joining("\n")));
        }
        if (!multiSources.isEmpty()) {
            MinestuckCompat.LOGGER.info("Items with multiple non-generated grist costs:\n{}", (Object)multiSources.entrySet().stream().map(MixinHooks::formatRecipeList).collect(Collectors.joining("\n")));
        }
    }

    public static Predicate<Item> getUnobtainableItemPredicate() {
        TagKey technicalItemsTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minestuckcompat", (String)"technical_items"));
        TagKey unobtainableItemsTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minestuckcompat", (String)"unobtainable_items"));
        TagKey extradelightButcherItemsTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minestuckcompat", (String)"extradelight_butchercraft_required"));
        HolderSet.Named technicalItems = (HolderSet.Named)BuiltInRegistries.ITEM.getTag(technicalItemsTag).orElseThrow();
        HolderSet.Named unobtainableItems = (HolderSet.Named)BuiltInRegistries.ITEM.getTag(unobtainableItemsTag).orElseThrow();
        HolderSet.Named extradelightButcherItems = ModList.get().isLoaded("extradelight") && !ModList.get().isLoaded("butchercraft") ? (HolderSet.Named)BuiltInRegistries.ITEM.getTag(extradelightButcherItemsTag).orElseThrow() : null;
        return item -> {
            if (item instanceof GameMasterBlockItem || item instanceof SpawnEggItem) {
                return true;
            }
            if (technicalItems.contains((Holder)item.builtInRegistryHolder())) {
                return true;
            }
            if (unobtainableItems.contains((Holder)item.builtInRegistryHolder())) {
                return true;
            }
            return extradelightButcherItems != null && extradelightButcherItems.contains((Holder)item.builtInRegistryHolder());
        };
    }

    public static <K, V> String formatRecipeList(Map.Entry<K, List<V>> entry) {
        String id = entry.getKey().toString();
        StringBuilder ret = new StringBuilder(id);
        for (V rl : entry.getValue()) {
            ret.append('\n').append("  ==> ").append(rl.toString());
        }
        return ret.toString();
    }

    public static void checkRecipesWithoutInterpreters(RecipeManager recipeManager, List<RecipeGeneratedCostHandler.SourceEntry> sources) {
        record Line(String id, String typeId, String serializerId) {
        }
        if (!MinestuckCompatConfig.common().dumpUnhandledRecipeTypes.getAsBoolean()) {
            return;
        }
        HashSet<RecipeHolder> recipes = new HashSet<RecipeHolder>(recipeManager.getRecipes());
        Set<String> impossibleRecipes = Set.of("mekanism:chemical_conversion", "mekanism:chemical_infusing", "mekanism:dissolution", "mekanism:evaporating", "mekanism:oxidizing", "mekanism:pigment_extracting", "mekanism:rotary", "mekanism:washing", "mekanism:centrifuging", "mekanism:separating", "mekanism:pigment_mixing", "mekanism:energy_conversion", "mekanism:activating", "mekanism:painting", "ae2:entropy", "ae2:matter_cannon", "create:emptying", "immersiveengineering:thermoelectric_source", "immersiveengineering:mineral_mix", "immersiveengineering:generator_fuel", "immersiveengineering:fertilizer", "immersiveengineering:cloche", "immersiveengineering:blast_furnace_fuel", "immersiveengineering:windmill_biome", "immersiveengineering:squeezer", "immersiveengineering:fermenter", "immersiveengineering:refinery", "immersiveengineering:mixer");
        Set<String> unsupportedRecipes = Set.of("minecraft:smithing", "minecraft:blasting", "minecraft:smoking", "minecraft:campfire_cooking", "mekanism:sawing", "mekanism:combining", "immersiveengineering:sawmill", "mekanism:crystallizing", "mekanism:reaction", "ae2:transform");
        recipes.removeIf(recipe -> {
            if (recipe.value().getType() == MSRecipeTypes.GRIST_COST_TYPE.get() || recipe.value().getType() == MSRecipeTypes.COMBINATION_TYPE.get()) {
                return true;
            }
            if (recipe.value() instanceof CustomRecipe || recipe.value() instanceof MapExtendingRecipe) {
                return true;
            }
            ResourceLocation typeId = BuiltInRegistries.RECIPE_TYPE.getKey((Object)recipe.value().getType());
            if (typeId != null) {
                if ("create".equals(typeId.getNamespace()) && recipe.id().getPath().contains("runtime_generated/")) {
                    return true;
                }
                String str = typeId.toString();
                if (impossibleRecipes.contains(str)) {
                    return true;
                }
                if (((Boolean)MinestuckCompatConfig.common().dumpUnhandledRecipeTypesFiltering.get()).booleanValue() && unsupportedRecipes.contains(str)) {
                    return true;
                }
            }
            return false;
        });
        for (RecipeGeneratedCostHandler.SourceEntry source : sources) {
            recipes.removeAll(source.source().findRecipes(recipeManager));
        }
        if (recipes.isEmpty()) {
            return;
        }
        List lines = recipes.stream().sorted(Comparator.comparing(r -> BuiltInRegistries.RECIPE_TYPE.getKey((Object)r.value().getType()), ResourceLocation::compareNamespaced).thenComparing(Comparator.comparing(RecipeHolder::id, ResourceLocation::compareNamespaced))).map(recipe -> new Line(recipe.id().toString(), BuiltInRegistries.RECIPE_TYPE.getKey((Object)recipe.value().getType()).toString(), BuiltInRegistries.RECIPE_SERIALIZER.getKey((Object)recipe.value().getSerializer()).toString())).collect(Collectors.toList());
        lines.add(0, new Line("ID", "Recipe Type", "Recipe Serializer"));
        int idWidth = 0;
        int typeWidth = 0;
        for (Line line2 : lines) {
            if (line2.id.length() > idWidth) {
                idWidth = line2.id.length();
            }
            if (line2.typeId.length() <= typeWidth) continue;
            typeWidth = line2.typeId.length();
        }
        int _idWidth = idWidth + 5;
        int _typeWidth = typeWidth + 5;
        MinestuckCompat.LOGGER.info("Unhandled recipes:\n{}", (Object)lines.stream().map(line -> line.id + " ".repeat(_idWidth - line.id.length()) + line.typeId + " ".repeat(_typeWidth - line.typeId.length()) + line.serializerId).collect(Collectors.joining("\n")));
    }

    private static void checkDuplicateCombinations(RecipeManager recipeManager) {
        List list = recipeManager.getAllRecipesFor((RecipeType)MSRecipeTypes.COMBINATION_TYPE.get());
        record Combination(Item a, Item b, boolean and) {
            Combination {
                if (a.builtInRegistryHolder().getRegisteredName().compareTo(b.builtInRegistryHolder().getRegisteredName()) < 0) {
                    Item temp = a;
                    a = b;
                    b = temp;
                }
            }
        }
        HashMap<Combination, ResourceLocation> usedCombinations = new HashMap<Combination, ResourceLocation>();
        for (RecipeHolder holder : list) {
            RegularCombinationRecipe recipe = (RegularCombinationRecipe)holder.value();
            ItemStack[] input1 = recipe.input1().getItems();
            ItemStack[] input2 = recipe.input2().getItems();
            if (input1.length == 1 && ItemStack.isSameItemSameComponents((ItemStack)input1[0], (ItemStack)recipe.output()) || input2.length == 1 && ItemStack.isSameItemSameComponents((ItemStack)input2[0], (ItemStack)recipe.output())) {
                MinestuckCompat.LOGGER.warn("Combination recipe {} is self-referential: {} + {} ==> {}", new Object[]{holder.id(), input1, input2, recipe.output().getItem()});
            }
            for (ItemStack stack1 : input1) {
                if (stack1.getItemHolder().getRegisteredName().contains("paxel")) continue;
                for (ItemStack stack2 : input2) {
                    if (stack2.getItemHolder().getRegisteredName().contains("paxel")) continue;
                    Combination combo = new Combination(stack1.getItem(), stack2.getItem(), recipe.mode() == CombinationMode.AND);
                    ResourceLocation conflict = usedCombinations.put(combo, holder.id());
                    if (conflict == null) continue;
                    MinestuckCompat.LOGGER.warn("Combination recipe {} conflicts with {}!", (Object)holder.id(), (Object)conflict);
                }
            }
        }
    }

    private static List<RecipeHolder<GristCostRecipe>> hasGristCost(ItemStack item, RecipeManager recipeManager) {
        List list = recipeManager.getAllRecipesFor((RecipeType)GristCostRecipe.RECIPE_TYPE.get());
        SingleRecipeInput input = new SingleRecipeInput(item);
        ArrayList<RecipeHolder<GristCostRecipe>> ret = new ArrayList<RecipeHolder<GristCostRecipe>>(1);
        for (RecipeHolder elem : list) {
            if (!((GristCostRecipe)elem.value()).matches((RecipeInput)input, null)) continue;
            ret.add((RecipeHolder<GristCostRecipe>)elem);
        }
        return ret;
    }
}

