/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.alchemy.analysis;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.block.plant.EndSaplingBlock;
import com.mraof.minestuck.block.plant.StrippableFlammableLogBlock;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.enderturret.minestuckcompat.MinestuckCompat;
import net.enderturret.minestuckcompat.alchemy.ClientDataManager;
import net.enderturret.minestuckcompat.alchemy.analysis.AnalyzedRecipe;
import net.enderturret.minestuckcompat.alchemy.analysis.SimpleIngredient;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CoralBlock;
import net.minecraft.world.level.block.CoralFanBlock;
import net.minecraft.world.level.block.CoralPlantBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;
import net.neoforged.neoforge.registries.datamaps.builtin.Oxidizable;
import net.neoforged.neoforge.registries.datamaps.builtin.Waxable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class BuiltinRecipeList {
    private static final Codec<SimpleIngredient> INGREDIENT_CODEC = ExtraCodecs.TAG_OR_ELEMENT_ID.flatXmap(BuiltinRecipeList::parseIngredient, ing -> DataResult.error(() -> "Cannot serialize SimpleIngredient"));
    private static final Codec<Item> LENIENT_ITEM_CODEC = ResourceLocation.CODEC.xmap(id -> {
        Optional optional = BuiltInRegistries.ITEM.getOptional(id);
        if (!optional.isPresent()) {
            BuiltinRecipeList.maybeWarn(id);
            return Items.AIR;
        }
        return (Item)optional.get();
    }, item -> item.builtInRegistryHolder().getKey().location());
    private static final Codec<AnalyzedRecipe> RECIPE_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)INGREDIENT_CODEC.listOf().fieldOf("inputs").forGetter(AnalyzedRecipe::inputs), (App)LENIENT_ITEM_CODEC.listOf().fieldOf("outputs").forGetter(AnalyzedRecipe::outputs)).apply((Applicative)builder, AnalyzedRecipe::fromCodec));
    private static final Codec<List<AnalyzedRecipe>> CODEC = RECIPE_CODEC.listOf();
    private static final Field CORAL_DEADBLOCK = ObfuscationReflectionHelper.findField(CoralBlock.class, (String)"deadBlock");
    private static final Field CORALFAN_DEADBLOCK = ObfuscationReflectionHelper.findField(CoralFanBlock.class, (String)"deadBlock");
    private static final Field CORALPLANT_DEADBLOCK = ObfuscationReflectionHelper.findField(CoralPlantBlock.class, (String)"deadBlock");
    private static final Field STRIPPABLEFLAMMABLELOG_STRIPPEDSTATE = ObfuscationReflectionHelper.findField(StrippableFlammableLogBlock.class, (String)"strippedState");

    static Set<Item> readRoots(ResourceManager resourceManager) {
        return Set.copyOf(BuiltinRecipeList.parseResource(resourceManager, "minestuckcompat/obtainability_analyzer", "minestuckcompat/obtainability_analyzer/roots.json", null, json -> {
            HashSet<Item> set = new HashSet<Item>();
            for (JsonElement elem : json.getAsJsonObject().asMap().values()) {
                for (JsonElement id : elem.getAsJsonArray()) {
                    set.addAll(((SimpleIngredient)INGREDIENT_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)id).getOrThrow()).items());
                }
            }
            return set;
        }));
    }

    static List<AnalyzedRecipe> scanRecipes(ResourceManager resourceManager) {
        ArrayList<AnalyzedRecipe> ret = new ArrayList<AnalyzedRecipe>();
        ret.addAll(BuiltinRecipeList.parseResource(resourceManager, "minestuckcompat/obtainability_analyzer", "minestuckcompat/obtainability_analyzer/recipes.json", null, elem -> (Collection)CODEC.parse((DynamicOps)JsonOps.INSTANCE, elem).getOrThrow()));
        ret.removeIf(recipe -> recipe.inputs().isEmpty() && recipe.outputs().isEmpty());
        BuiltinRecipeList.detectRecipesFromRuntime(ret);
        return ret;
    }

    public static <T> List<T> parseResource(ResourceManager resourceManager, String folder, String path, @Nullable String excludedNamespace, Function<JsonElement, Collection<T>> codec) {
        ArrayList<T> ret = new ArrayList<T>();
        for (Map.Entry entry : resourceManager.listResources(folder, rl -> rl.getPath().equals(path)).entrySet()) {
            try {
                BufferedReader br = ((Resource)entry.getValue()).openAsReader();
                try {
                    JsonElement elem = JsonParser.parseReader((Reader)br);
                    ret.addAll(codec.apply(elem));
                }
                finally {
                    if (br == null) continue;
                    br.close();
                }
            }
            catch (Exception e) {
                MinestuckCompat.LOGGER.warn("Exception reading {}:", entry.getKey(), (Object)e);
            }
        }
        return ret;
    }

    private static void detectRecipesFromRuntime(List<AnalyzedRecipe> recipes) {
        Block from;
        Object stripped;
        for (Holder holder : (HolderSet.Named)BuiltInRegistries.BLOCK.getTag(BlockTags.LOGS).get()) {
            stripped = AxeItem.getAxeStrippingState((BlockState)((Block)holder.value()).defaultBlockState());
            if (stripped == null) continue;
            recipes.add(AnalyzedRecipe.singleInput((ItemLike)holder.value(), new ItemLike[]{stripped.getBlock()}));
        }
        for (Map.Entry entry : BuiltInRegistries.BLOCK.getDataMap(NeoForgeDataMaps.OXIDIZABLES).entrySet()) {
            from = (Block)BuiltInRegistries.BLOCK.get((ResourceKey)entry.getKey());
            recipes.add(AnalyzedRecipe.singleInput((ItemLike)from, new ItemLike[]{((Oxidizable)entry.getValue()).nextOxidationStage()}));
        }
        for (Map.Entry entry : BuiltInRegistries.BLOCK.getDataMap(NeoForgeDataMaps.WAXABLES).entrySet()) {
            from = (Block)BuiltInRegistries.BLOCK.get((ResourceKey)entry.getKey());
            recipes.add(AnalyzedRecipe.twoInputs((ItemLike)from, (ItemLike)Items.HONEYCOMB, new ItemLike[]{((Waxable)entry.getValue()).waxed()}));
        }
        for (Map.Entry<Object, Object> entry : ClientDataManager.SWAPPING_WEAPONS.entrySet()) {
            recipes.add(AnalyzedRecipe.singleInput((ItemLike)entry.getKey(), (ItemLike)entry.getValue()));
            recipes.add(AnalyzedRecipe.singleInput((ItemLike)entry.getValue(), (ItemLike)entry.getKey()));
        }
        try {
            for (Block block : BuiltInRegistries.BLOCK) {
                if (block instanceof SaplingBlock || block instanceof EndSaplingBlock) {
                    Optional leaves;
                    ResourceLocation id = block.builtInRegistryHolder().getKey().location();
                    if (!id.getPath().endsWith("_sapling")) continue;
                    String base = id.getPath().substring(0, id.getPath().length() - "_sapling".length());
                    Optional log = BuiltInRegistries.BLOCK.getOptional(id.withPath(base + "_log"));
                    if (log.isPresent()) {
                        recipes.add(AnalyzedRecipe.singleInput((ItemLike)block, (ItemLike)log.get()));
                    }
                    if (!(leaves = BuiltInRegistries.BLOCK.getOptional(id.withPath(base + "_leaves"))).isPresent()) continue;
                    recipes.add(AnalyzedRecipe.twoInputs((ItemLike)block, (ItemLike)Items.SHEARS, (ItemLike)leaves.get()));
                    continue;
                }
                if (block instanceof CoralBlock) {
                    recipes.add(AnalyzedRecipe.singleInput((ItemLike)block, new ItemLike[]{(Block)CORAL_DEADBLOCK.get(block)}));
                    continue;
                }
                if (block instanceof CoralFanBlock) {
                    recipes.add(AnalyzedRecipe.singleInput((ItemLike)block, new ItemLike[]{(Block)CORALFAN_DEADBLOCK.get(block)}));
                    continue;
                }
                if (block instanceof CoralPlantBlock) {
                    recipes.add(AnalyzedRecipe.singleInput((ItemLike)block, new ItemLike[]{(Block)CORALPLANT_DEADBLOCK.get(block)}));
                    continue;
                }
                if (!(block instanceof StrippableFlammableLogBlock)) continue;
                stripped = (Supplier)STRIPPABLEFLAMMABLELOG_STRIPPEDSTATE.get(block);
                recipes.add(AnalyzedRecipe.singleInput((ItemLike)block, new ItemLike[]{((BlockState)stripped.get()).getBlock()}));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static DataResult<SimpleIngredient> parseIngredient(ExtraCodecs.TagOrElementLocation loc) {
        if (loc.tag()) {
            return DataResult.success((Object)SimpleIngredient.of((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)loc.id())));
        }
        Optional item = BuiltInRegistries.ITEM.getOptional(loc.id());
        if (!item.isPresent()) {
            BuiltinRecipeList.maybeWarn(loc.id());
            return DataResult.success((Object)SimpleIngredient.INVALID);
        }
        return DataResult.success((Object)SimpleIngredient.of((ItemLike)item.get()));
    }

    private static void maybeWarn(ResourceLocation id) {
        String domain = id.getNamespace();
        if (BuiltInRegistries.ITEM.holders().anyMatch(holder -> domain.equals(holder.getKey().location().getNamespace()))) {
            MinestuckCompat.LOGGER.warn("Unknown item ID in analyzer recipes: {}", (Object)id);
        }
    }
}

