/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.alchemy.analysis;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mraof.minestuck.alchemy.recipe.RegularCombinationRecipe;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeGeneratedCostHandler;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeInterpreter;
import com.mraof.minestuck.api.alchemy.recipe.generator.LookupTracker;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.enderturret.minestuckcompat.MinestuckCompat;
import net.enderturret.minestuckcompat.MinestuckCompatConfig;
import net.enderturret.minestuckcompat.alchemy.MixinHooks;
import net.enderturret.minestuckcompat.alchemy.analysis.AnalyzedRecipe;
import net.enderturret.minestuckcompat.alchemy.analysis.AnalyzingLookupTracker;
import net.enderturret.minestuckcompat.alchemy.analysis.BuiltinRecipeList;
import net.enderturret.minestuckcompat.alchemy.analysis.CombinationRecipeInterpreter;
import net.enderturret.minestuckcompat.alchemy.analysis.SimpleIngredient;
import net.enderturret.minestuckcompat.api.alchemy.AnalyzableRecipeInterpreter;
import net.enderturret.minestuckcompat.api.alchemy.GenerateGristCostsEvent;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.Nullable;

public final class ObtainabilityAnalyzer {
    private final RecipeManager recipeManager;
    private final ResourceManager resourceManager;
    private final Map<Recipe<?>, RecipeInterpreter> interpretersByRecipe;

    public ObtainabilityAnalyzer(RecipeManager recipeManager, ResourceManager resourceManager) {
        this.recipeManager = recipeManager;
        this.resourceManager = resourceManager;
        this.interpretersByRecipe = ObtainabilityAnalyzer.readInterpreters(recipeManager, resourceManager);
    }

    public List<Item> check(@Nullable BiConsumer<Component, Boolean> messageConsumer) {
        Set<Item> roots = this.defineDefaultRoots();
        if (roots.isEmpty()) {
            MinestuckCompat.LOGGER.warn("Attempted to perform obtainability analysis with 0 roots!");
            if (messageConsumer != null) {
                messageConsumer.accept((Component)Component.translatable((String)"minestuckcompat.analyzer.no_roots"), true);
            }
            return List.of();
        }
        MinestuckCompat.LOGGER.info("Beginning obtainability analysis with {} roots!", (Object)roots.size());
        if (messageConsumer != null) {
            messageConsumer.accept((Component)Component.translatable((String)"minestuckcompat.analyzer.starting", (Object[])new Object[]{Component.literal((String)Integer.toString(roots.size())).withStyle(ChatFormatting.GREEN)}), false);
        }
        Map<Item, List<AnalyzedRecipe>> relevantRecipes = this.buildRelevantRecipes();
        MinestuckCompat.LOGGER.info("Built relevant recipes for {} ingredients!", (Object)relevantRecipes.size());
        long start = System.currentTimeMillis();
        HashSet<Item> obtainable = new HashSet<Item>(roots);
        ArrayList<Item> newlyObtainable = new ArrayList<Item>(roots);
        while (!newlyObtainable.isEmpty()) {
            Item item2 = (Item)newlyObtainable.removeFirst();
            List recipes = relevantRecipes.getOrDefault(item2, List.of());
            Iterator it = recipes.iterator();
            block1: while (it.hasNext()) {
                AnalyzedRecipe recipe = (AnalyzedRecipe)it.next();
                for (SimpleIngredient input : recipe.inputs()) {
                    boolean matches = false;
                    for (Item i : input.items()) {
                        if (!obtainable.contains(i)) continue;
                        matches = true;
                    }
                    if (matches) continue;
                    continue block1;
                }
                for (Item out : recipe.outputs()) {
                    if (!obtainable.add(out)) continue;
                    newlyObtainable.add(out);
                }
                it.remove();
            }
        }
        Predicate<Item> filter = MixinHooks.getUnobtainableItemPredicate();
        List<Item> unobtainable = BuiltInRegistries.ITEM.stream().filter(item -> {
            if (item instanceof MobBucketItem || filter.test((Item)item)) {
                return false;
            }
            Holder.Reference holder = item.builtInRegistryHolder();
            String domain = holder.getKey().location().getNamespace();
            if ("rechiseled".equals(domain)) {
                return false;
            }
            return !obtainable.contains(item);
        }).sorted(Comparator.comparing(item -> item.builtInRegistryHolder().getKey().location(), ResourceLocation::compareNamespaced)).toList();
        long end = System.currentTimeMillis();
        String time = "%.3f".formatted((double)(end - start) / 1000.0);
        MinestuckCompat.LOGGER.info("Analysis completed with {} obtainable items! Took {} s.", (Object)obtainable.size(), (Object)time);
        MinestuckCompat.LOGGER.info("Analysis identified {} unobtainable items. Check the file for details.", (Object)unobtainable.size());
        if (messageConsumer != null) {
            messageConsumer.accept((Component)Component.translatable((String)"minestuckcompat.analyzer.completed.1", (Object[])new Object[]{Component.literal((String)Integer.toString(obtainable.size())).withStyle(ChatFormatting.GREEN), Component.literal((String)time).withStyle(ChatFormatting.GREEN)}), false);
            messageConsumer.accept((Component)Component.translatable((String)"minestuckcompat.analyzer.completed.2", (Object[])new Object[]{Component.literal((String)Integer.toString(unobtainable.size())).withStyle(ChatFormatting.GREEN)}), false);
        }
        if (!unobtainable.isEmpty()) {
            ObtainabilityAnalyzer.dumpUnobtainables(relevantRecipes, obtainable, unobtainable);
        }
        return unobtainable;
    }

    private Set<Item> defineDefaultRoots() {
        return BuiltinRecipeList.readRoots(this.resourceManager);
    }

    private static void dumpUnobtainables(Map<Item, List<AnalyzedRecipe>> relevantRecipes, Set<Item> obtainable, List<Item> unobtainable) {
        try {
            Files.writeString(Paths.get("analyzer_unobtainables.txt", new String[0]), (CharSequence)unobtainable.stream().map(item -> item.builtInRegistryHolder().getRegisteredName()).collect(Collectors.joining("\n")), new OpenOption[0]);
        }
        catch (IOException e) {
            MinestuckCompat.LOGGER.warn("Failed to write analyzer output:", (Throwable)e);
        }
    }

    private static Map<Recipe<?>, RecipeInterpreter> readInterpreters(RecipeManager recipeManager, ResourceManager resourceManager) {
        ArrayList sources = new ArrayList();
        ConditionalOps ops = new ConditionalOps(RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)VanillaRegistries.createLookup()), ICondition.IContext.EMPTY);
        sources.addAll(BuiltinRecipeList.parseResource(resourceManager, "minestuck", "minestuck/grist_cost_generation_recipes.json", MinestuckCompatConfig.common().useExtraStuckInterpreters.getAsBoolean() ? null : "extrastuck", json -> ((List)MixinHooks.CONDITIONAL_SOURCE_ENTRY_LIST.parse((DynamicOps)ops, json).getOrThrow(RuntimeException::new)).stream().filter(Optional::isPresent).map(Optional::get).toList()));
        HashMap ret = new HashMap();
        for (RecipeGeneratedCostHandler.SourceEntry source : sources) {
            for (RecipeHolder recipe : source.source().findRecipes(recipeManager)) {
                ret.put(recipe.value(), source.interpreter());
            }
        }
        return ret;
    }

    @Nullable
    private RecipeInterpreter findInterpreter(Recipe<?> recipe) {
        if (recipe instanceof RegularCombinationRecipe) {
            return CombinationRecipeInterpreter.INSTANCE;
        }
        return this.interpretersByRecipe.get(recipe);
    }

    private Map<Item, List<AnalyzedRecipe>> buildRelevantRecipes() {
        HashMap<Item, List<AnalyzedRecipe>> ret = new HashMap<Item, List<AnalyzedRecipe>>();
        NeoForge.EVENT_BUS.post((Event)new GenerateGristCostsEvent.Pre(this.recipeManager));
        for (RecipeHolder recipeHolder : this.recipeManager.getRecipes()) {
            RecipeInterpreter interpreter = this.findInterpreter(recipeHolder.value());
            if (interpreter == null) continue;
            List outputs = interpreter.getOutputItems(recipeHolder.value());
            List<SimpleIngredient> inputs = ObtainabilityAnalyzer.getInputs(recipeHolder.value(), interpreter);
            AnalyzedRecipe analyzed = new AnalyzedRecipe(inputs, outputs);
            HashSet<Item> uniqueInputs = new HashSet<Item>();
            for (SimpleIngredient input : inputs) {
                for (Item item : input.items()) {
                    if (!uniqueInputs.add(item)) continue;
                    ret.computeIfAbsent(item, k -> new ArrayList()).add(analyzed);
                }
            }
        }
        for (AnalyzedRecipe analyzedRecipe : BuiltinRecipeList.scanRecipes(this.resourceManager)) {
            for (SimpleIngredient input : analyzedRecipe.inputs()) {
                for (Item item : input.items()) {
                    ret.computeIfAbsent(item, k -> new ArrayList()).add(analyzedRecipe);
                }
            }
        }
        NeoForge.EVENT_BUS.post((Event)new GenerateGristCostsEvent.Post(this.recipeManager));
        return ret;
    }

    private static List<SimpleIngredient> getInputs(Recipe<?> recipe, RecipeInterpreter interpreter) {
        AnalyzingLookupTracker tracker = new AnalyzingLookupTracker();
        interpreter.reportPreliminaryLookups(recipe, (LookupTracker)tracker);
        if (interpreter instanceof AnalyzableRecipeInterpreter) {
            AnalyzableRecipeInterpreter analyzable = (AnalyzableRecipeInterpreter)interpreter;
            analyzable.reportCraftingStation(recipe, tracker);
        }
        return List.copyOf(tracker.getIngredients());
    }
}

