/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.alchemy.extradelight;

import com.lance5057.extradelight.blocks.RecipeFeastBlock;
import com.lance5057.extradelight.blocks.RecipeFondueFeastBlock;
import com.lance5057.extradelight.recipe.FeastRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeInterpreter;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import com.mraof.minestuck.api.alchemy.recipe.generator.LookupTracker;
import java.util.List;
import net.enderturret.minestuckcompat.MinestuckCompat;
import net.enderturret.minestuckcompat.api.alchemy.AbstractCostAddingRecipeInterpreter;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.PieBlock;

public final class FeastInterpreter
extends AbstractCostAddingRecipeInterpreter.Typed<FeastRecipe> {
    public static final MapCodec<FeastInterpreter> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)COST_FIELD.forGetter(AbstractCostAddingRecipeInterpreter::addedCost)).apply((Applicative)instance, FeastInterpreter::new));

    public FeastInterpreter(GristSet.Immutable addedCost) {
        super(FeastRecipe.class, addedCost);
    }

    public MapCodec<? extends RecipeInterpreter> codec() {
        return CODEC;
    }

    @Override
    protected List<ItemStack> getOutputItemStacksTyped(FeastRecipe recipe) {
        return List.of(recipe.getResultItem(null));
    }

    @Override
    @Nullable
    protected MutableGristSet ingredientCost(Recipe<?> recipe, GeneratorCallback callback) {
        return MutableGristSet.newDefault();
    }

    @Override
    @Nullable
    protected MutableGristSet generateCost(MutableGristSet totalCost, FeastRecipe recipe, Item output, GeneratorCallback callback) {
        if (!FeastInterpreter.account(totalCost, callback, recipe.getFeastStack().getItem())) {
            return null;
        }
        if (!FeastInterpreter.account(totalCost, callback, recipe.getContainer())) {
            return null;
        }
        return totalCost;
    }

    @Override
    @Nullable
    protected GristSet finalizeGristCosts(@Nullable MutableGristSet totalCost, Recipe<?> recipe, Item output) {
        if (recipe instanceof FeastRecipe) {
            int result;
            FeastRecipe r = (FeastRecipe)recipe;
            Block block = r.getFeast().getBlock();
            if (block instanceof RecipeFeastBlock) {
                RecipeFeastBlock feast = (RecipeFeastBlock)block;
                result = feast.getMaxServings();
            } else if (block instanceof RecipeFondueFeastBlock) {
                RecipeFondueFeastBlock feast = (RecipeFondueFeastBlock)block;
                result = feast.getMaxServings();
            } else if (block instanceof PieBlock) {
                PieBlock pie = (PieBlock)block;
                result = pie.getMaxBites();
            } else {
                MinestuckCompat.LOGGER.warn("[ExtraDelight] Unknown feast block type {}", block.getClass());
                result = 1;
            }
            return this.finalizeGristCosts(totalCost, result);
        }
        return super.finalizeGristCosts(totalCost, recipe, output);
    }

    @Override
    protected void reportPreliminaryLookupsTyped(FeastRecipe recipe, LookupTracker tracker) {
        tracker.report(recipe.getFeastStack());
        tracker.report(recipe.getContainer());
    }
}

