/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.alchemy.mekanism;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.MekanismRecipeTypes;
import mekanism.api.recipes.basic.BasicChemicalConversionRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.enderturret.minestuckcompat.api.alchemy.GenerateGristCostsEvent;
import net.minecraft.core.Holder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.bus.api.SubscribeEvent;
import org.jetbrains.annotations.Nullable;

public final class ChemicalConversionManager {
    @Nullable
    private static Map<Holder<Chemical>, List<ChemicalConversion>> chemicalToItem;

    public static List<ChemicalConversion> getConversions(Holder<Chemical> chemical) {
        return Objects.requireNonNull(chemicalToItem, "getConversions() called outside of grist cost generation!").get(chemical);
    }

    @SubscribeEvent
    static void beforeGristCostGeneration(GenerateGristCostsEvent.Pre e) {
        chemicalToItem = new HashMap<Holder<Chemical>, List<ChemicalConversion>>();
        for (RecipeHolder recipeHolder : e.getRecipeManager().getAllRecipesFor((RecipeType)MekanismRecipeTypes.TYPE_CHEMICAL_CONVERSION.get())) {
            BasicChemicalConversionRecipe recipe = (BasicChemicalConversionRecipe)recipeHolder.value();
            ItemStackIngredient input = recipe.getInput();
            ChemicalStack output = recipe.getOutputRaw();
            List list = chemicalToItem.computeIfAbsent((Holder<Chemical>)output.getChemicalHolder(), k -> new ArrayList());
            for (ItemStack stack : input.getRepresentations()) {
                list.add(new ChemicalConversion((Holder<Item>)stack.getItemHolder(), (int)output.getAmount()));
            }
        }
        for (Holder holder : chemicalToItem.keySet()) {
            chemicalToItem.compute((Holder<Chemical>)holder, (k, v) -> List.copyOf(Set.copyOf(v)));
        }
    }

    @SubscribeEvent
    static void afterGristCostGeneration(GenerateGristCostsEvent.Post e) {
        chemicalToItem = null;
    }

    public record ChemicalConversion(Holder<Item> item, int worth) {
    }
}

