/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.alchemy.mekanism;

import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import com.mraof.minestuck.api.alchemy.recipe.generator.LookupTracker;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mekanism.api.chemical.Chemical;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import net.enderturret.minestuckcompat.alchemy.analysis.AnalyzingLookupTracker;
import net.enderturret.minestuckcompat.alchemy.mekanism.ChemicalConversionManager;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public final class ChemicalHelper {
    public static boolean account(MutableGristSet total, GeneratorCallback callback, ChemicalStackIngredient ingredient) {
        MutableObject conversion = new MutableObject(null);
        GristSet cost = ChemicalHelper.lookup(callback, ingredient.ingredient(), (MutableObject<ChemicalConversionManager.ChemicalConversion>)conversion);
        if (cost == null) {
            return false;
        }
        ChemicalHelper.addScaled(total, cost, (double)ingredient.amount() / (double)((ChemicalConversionManager.ChemicalConversion)conversion.getValue()).worth());
        return true;
    }

    @Nullable
    public static GristSet lookup(GeneratorCallback callback, ChemicalIngredient ingredient, @Nullable MutableObject<ChemicalConversionManager.ChemicalConversion> conversion) {
        if (ingredient.hasNoChemicals()) {
            return GristSet.EMPTY;
        }
        GristSet minCost = null;
        ChemicalConversionManager.ChemicalConversion minCon = null;
        for (Holder holder : ingredient.getChemicalHolders()) {
            List<ChemicalConversionManager.ChemicalConversion> conversions = ChemicalConversionManager.getConversions((Holder<Chemical>)holder);
            if (conversions == null) continue;
            for (ChemicalConversionManager.ChemicalConversion con : conversions) {
                GristSet set = callback.lookupCostFor((Item)con.item().value());
                if (set == null || minCost != null && !(set.getValue() / (double)con.worth() < minCost.getValue() / (double)minCon.worth())) continue;
                minCost = set;
                minCon = con;
            }
        }
        if (conversion != null) {
            conversion.setValue(minCon);
        }
        return minCost;
    }

    public static void report(LookupTracker tracker, ChemicalIngredient chemical) {
        HashSet<Item> items = new HashSet<Item>();
        for (Holder holder : chemical.getChemicalHolders()) {
            List<ChemicalConversionManager.ChemicalConversion> conversions = ChemicalConversionManager.getConversions((Holder<Chemical>)holder);
            if (conversions == null) continue;
            for (ChemicalConversionManager.ChemicalConversion con : conversions) {
                items.add((Item)con.item().value());
            }
        }
        if (tracker instanceof AnalyzingLookupTracker) {
            AnalyzingLookupTracker analyzing = (AnalyzingLookupTracker)tracker;
            analyzing.report(List.copyOf(items));
        } else {
            for (Item item : items) {
                tracker.report(item);
            }
        }
    }

    public static void addScaled(MutableGristSet target, GristSet value, double scale) {
        for (Map.Entry entry : value.asMap().entrySet()) {
            long scaled = Mth.ceil((double)((double)((Long)entry.getValue()).longValue() * scale));
            target.add((GristType)entry.getKey(), scaled < 1L ? 1L : scaled);
        }
    }
}

