/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.api.alchemy;

import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import com.mraof.minestuck.api.alchemy.recipe.generator.LookupTracker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.enderturret.minestuckcompat.alchemy.analysis.AnalyzingLookupTracker;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.Nullable;

public final class FluidHelper {
    private static final int BUCKET_SIZE = 1000;

    public static boolean account(MutableGristSet total, GeneratorCallback callback, SizedFluidIngredient ingredient) {
        return FluidHelper.account(total, callback, Arrays.asList(ingredient.ingredient().getStacks()), ingredient.amount());
    }

    public static boolean account(MutableGristSet total, GeneratorCallback callback, FluidIngredient ingredient) {
        return FluidHelper.account(total, callback, Arrays.asList(ingredient.getStacks()), 1000);
    }

    public static boolean account(MutableGristSet total, GeneratorCallback callback, Collection<FluidStack> ingredient, int count) {
        MutableGristSet best = null;
        for (FluidStack stack : ingredient) {
            MutableGristSet cost = FluidHelper.lookup(stack, callback);
            if (best != null && (cost == null || !(best.getValue() > cost.getValue()))) continue;
            best = cost;
        }
        if (best != null) {
            float scale = (float)count / 1000.0f;
            best.scale(scale, false);
            total.add((GristSet)best);
            return true;
        }
        return false;
    }

    @Nullable
    public static MutableGristSet lookup(FluidStack fluid, GeneratorCallback callback) {
        ItemStack bucket = fluid.getFluidType().getBucket(fluid);
        GristSet bucketCost = callback.lookupCostFor(bucket);
        if (bucketCost == null) {
            return null;
        }
        ItemStack remainder = bucket.getCraftingRemainingItem();
        GristSet remainderCost = callback.lookupCostFor(remainder);
        if (remainderCost == null) {
            return null;
        }
        return remainderCost.mutableCopy().scale(-1).add(bucketCost);
    }

    public static void report(LookupTracker tracker, FluidStack fluid) {
        tracker.report(fluid.getFluidType().getBucket(fluid));
    }

    public static void report(LookupTracker tracker, FluidIngredient fluid) {
        FluidHelper.report(tracker, Arrays.asList(fluid.getStacks()));
    }

    public static void report(LookupTracker tracker, Collection<FluidStack> fluid) {
        if (tracker instanceof AnalyzingLookupTracker) {
            AnalyzingLookupTracker t = (AnalyzingLookupTracker)tracker;
            ArrayList<Item> ingredient = new ArrayList<Item>();
            for (FluidStack stack : fluid) {
                ingredient.add(stack.getFluidType().getBucket(stack).getItem());
            }
            t.report(ingredient);
            return;
        }
        for (FluidStack stack : fluid) {
            FluidHelper.report(tracker, stack);
        }
    }
}

