/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.api.alchemy;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeInterpreter;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import net.enderturret.minestuckcompat.api.alchemy.AbstractCostAddingRecipeInterpreter;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.Nullable;

public final class SimpleRecipeInterpreter
extends AbstractCostAddingRecipeInterpreter {
    public static final MapCodec<SimpleRecipeInterpreter> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("ignore_special", (Object)true).forGetter(SimpleRecipeInterpreter::ignoreSpecial), (App)GristSet.Codecs.MAP_CODEC.optionalFieldOf("added_cost", (Object)GristSet.EMPTY).forGetter(AbstractCostAddingRecipeInterpreter::addedCost)).apply((Applicative)instance, SimpleRecipeInterpreter::new));
    private final boolean ignoreSpecial;

    public SimpleRecipeInterpreter(boolean ignoreSpecial, GristSet.Immutable addedCost) {
        super(addedCost);
        this.ignoreSpecial = ignoreSpecial;
    }

    public SimpleRecipeInterpreter(boolean ignoreSpecial) {
        this(ignoreSpecial, GristSet.EMPTY);
    }

    public boolean ignoreSpecial() {
        return this.ignoreSpecial;
    }

    public MapCodec<? extends RecipeInterpreter> codec() {
        return CODEC;
    }

    @Override
    @Nullable
    public GristSet generateCost(Recipe<?> recipe, Item output, GeneratorCallback callback) {
        if (this.ignoreSpecial && recipe.isSpecial()) {
            return null;
        }
        MutableGristSet totalCost = this.ingredientCost(recipe, callback);
        if (totalCost == null) {
            return null;
        }
        return this.finalizeGristCosts(totalCost, recipe, output);
    }
}

