/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.perf;

import com.mraof.minestuck.api.alchemy.GristAmount;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.enderturret.minestuckcompat.perf.GristTypeHelper;
import net.enderturret.minestuckcompat.perf.SmallImmutableGristSet;
import net.enderturret.minestuckcompat.perf.SmallMutableGristSet;
import org.jetbrains.annotations.Nullable;

abstract sealed class AbstractSmallGristSet
implements GristSet
permits SmallImmutableGristSet, SmallMutableGristSet {
    final int[] gristByType;

    AbstractSmallGristSet(int[] gristByType) {
        this.gristByType = gristByType;
    }

    @Nullable
    static int[] gristByType(GristSet set, boolean emptyToNull) {
        int[] gristByType = new int[GristTypeHelper.size()];
        boolean empty = true;
        for (int i = 0; i < gristByType.length; ++i) {
            GristType type = GristTypeHelper.type(i);
            if (!set.hasType(type)) continue;
            empty = false;
            gristByType[i] = (int)set.getGrist(type);
        }
        return (int[])(empty && emptyToNull ? null : gristByType);
    }

    @Nullable
    static int[] gristByType(Map<GristType, Long> map, boolean emptyToNull) {
        int[] gristByType = new int[GristTypeHelper.size()];
        boolean empty = true;
        for (int i = 0; i < gristByType.length; ++i) {
            GristType type = GristTypeHelper.type(i);
            if (!map.containsKey(type)) continue;
            empty = false;
            gristByType[i] = map.get(type).intValue();
        }
        return (int[])(empty && emptyToNull ? null : gristByType);
    }

    static int[] gristByType(List<GristAmount> list) {
        int[] gristByType = new int[GristTypeHelper.size()];
        for (GristAmount amt : list) {
            int index = GristTypeHelper.id(amt.type());
            gristByType[index] = (int)amt.amount();
        }
        return gristByType;
    }

    public Map<GristType, Long> asMap() {
        Object2LongOpenHashMap ret = new Object2LongOpenHashMap();
        for (int i = 0; i < this.gristByType.length; ++i) {
            if (this.gristByType[i] == 0) continue;
            GristType type = GristTypeHelper.type(i);
            ret.put((Object)type, (long)this.gristByType[i]);
        }
        return ret;
    }

    public List<GristAmount> asAmounts() {
        ArrayList<GristAmount> ret = new ArrayList<GristAmount>();
        for (int i = 0; i < this.gristByType.length; ++i) {
            if (this.gristByType[i] == 0) continue;
            GristType type = GristTypeHelper.type(i);
            ret.add(new GristAmount(type, (long)this.gristByType[i]));
        }
        return ret;
    }

    public long getGrist(GristType type) {
        return this.gristByType[GristTypeHelper.id(type)];
    }

    public boolean hasType(GristType type) {
        return this.gristByType[GristTypeHelper.id(type)] != 0;
    }

    public boolean isEmpty() {
        for (int i : this.gristByType) {
            if (i == 0) continue;
            return false;
        }
        return true;
    }

    public MutableGristSet mutableCopy() {
        return new SmallMutableGristSet((int[])this.gristByType.clone());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append(" { ");
        boolean first = true;
        for (int i = 0; i < this.gristByType.length; ++i) {
            if (this.gristByType[i] == 0) continue;
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            GristType type = GristTypeHelper.type(i);
            sb.append(type.getId().getPath()).append(" x").append(this.gristByType[i]);
        }
        sb.append(" }");
        return sb.toString();
    }
}

