/*
 * Decompiled with CFR 0.152.
 */
package computer.livingroom.screentoclip;

import computer.livingroom.screentoclip.ScreenToClip;
import computer.livingroom.screentoclip.mixin.NativeImagePointerAccessor;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.nio.ByteBuffer;
import net.minecraft.class_1011;
import net.minecraft.class_156;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryUtil;

public class HandleImage {
    public static void init() {
        if (class_156.method_668() != class_156.class_158.field_1137) {
            try {
                Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (HeadlessException e) {
                ScreenToClip.LOGGER.warn("java.awt.headless property was not set properly!");
            }
        }
    }

    public static void handleScreenshotAWT(class_1011 img) {
        if (class_156.method_668() == class_156.class_158.field_1137) {
            return;
        }
        if (img.method_4318() != class_1011.class_1012.field_4997) {
            ScreenToClip.LOGGER.warn("Failed to capture screenshot: wrong format");
            return;
        }
        long imagePointer = ((NativeImagePointerAccessor)img).getPointer();
        ByteBuffer buf = MemoryUtil.memByteBufferSafe((long)imagePointer, (int)(img.method_4307() * img.method_4323() * 4));
        if (buf == null) {
            throw new RuntimeException("Invalid image");
        }
        HandleImage.handleScreenshotAWT(buf, img.method_4307(), img.method_4323(), 4);
    }

    private static void handleScreenshotAWT(ByteBuffer byteBuffer, int width, int height, int components) {
        byte[] array;
        if (class_156.method_668() == class_156.class_158.field_1137) {
            return;
        }
        if (byteBuffer.hasArray()) {
            array = byteBuffer.array();
        } else {
            array = new byte[height * width * components];
            byteBuffer.get(array);
        }
        HandleImage.doCopy(array, width, height, components);
    }

    private static void doCopy(byte[] imageData, int width, int height, int components) {
        new Thread(() -> {
            DataBufferByte buf = new DataBufferByte(imageData, imageData.length);
            ColorSpace cs = ColorSpace.getInstance(1000);
            int[] nBits = new int[]{8, 8, 8};
            int[] bOffs = new int[]{0, 1, 2};
            ComponentColorModel cm = new ComponentColorModel(cs, nBits, false, false, 3, 0);
            BufferedImage bufImg = new BufferedImage(cm, Raster.createInterleavedRaster(buf, width, height, width * components, components, bOffs, null), false, null);
            Transferable trans = HandleImage.getTransferableImage(bufImg);
            Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
            c.setContents(trans, null);
        }, "Screenshot to Clipboard Copy").start();
    }

    private static Transferable getTransferableImage(final BufferedImage bufferedImage) {
        return new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.imageFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return DataFlavor.imageFlavor.equals(flavor);
            }

            @Override
            @NotNull
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (DataFlavor.imageFlavor.equals(flavor)) {
                    return bufferedImage;
                }
                throw new UnsupportedFlavorException(flavor);
            }
        };
    }
}

