/*
 * Decompiled with CFR 0.152.
 */
package yoflixxz.defaultspigot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class CalculatorPlugin
extends JavaPlugin {
    private FileConfiguration config;
    private ScriptEngine scriptEngine;
    private boolean useScriptEngine;
    private String prefix;
    private String errorColor;
    private String resultColor;
    private String operationColor;

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.loadConfigValues();
        this.scriptEngine = new ScriptEngineManager().getEngineByName("JavaScript");
        if (this.scriptEngine == null) {
            this.getLogger().warning("JavaScript engine not found, falling back to basic operations.");
            this.useScriptEngine = false;
        }
        this.getCommand("calculate").setExecutor((CommandExecutor)new CalculatorCommand());
        this.getCommand("calculate").setTabCompleter((TabCompleter)new CalculatorTabCompleter());
        this.getCommand("calc").setExecutor((CommandExecutor)new CalculatorCommand());
        this.getCommand("calc").setTabCompleter((TabCompleter)new CalculatorTabCompleter());
        this.getCommand("c").setExecutor((CommandExecutor)new CalculatorCommand());
        this.getCommand("c").setTabCompleter((TabCompleter)new CalculatorTabCompleter());
        this.getLogger().info("CalculatorPlugin enabled!");
    }

    private void loadConfigValues() {
        this.useScriptEngine = this.config.getBoolean("use-script-engine", true);
        this.prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("messages.prefix", "&6[Calculator] "));
        this.errorColor = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("messages.error-color", "&c"));
        this.resultColor = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("messages.result-color", "&a"));
        this.operationColor = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("messages.operation-color", "&e"));
    }

    private class CalculatorCommand
    implements CommandExecutor {
        private CalculatorCommand() {
        }

        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (!sender.hasPermission("calculator.use")) {
                sender.sendMessage(CalculatorPlugin.this.prefix + CalculatorPlugin.this.errorColor + CalculatorPlugin.this.config.getString("messages.no-permission", "You don't have permission to use this command!"));
                return true;
            }
            if (args.length == 0) {
                String usageMessage = label.equalsIgnoreCase("c") ? "usage: /c <number> <operator> <number>" : CalculatorPlugin.this.config.getString("messages.usage", "Usage: /%command% <expression>").replace("%command%", label);
                sender.sendMessage(CalculatorPlugin.this.prefix + CalculatorPlugin.this.errorColor + usageMessage);
                return true;
            }
            String expression = String.join((CharSequence)" ", args);
            try {
                double result = CalculatorPlugin.this.useScriptEngine && CalculatorPlugin.this.scriptEngine != null ? this.evaluateWithScriptEngine(expression) : this.evaluateBasicExpression(expression);
                String formattedResult = CalculatorPlugin.this.config.getBoolean("format.decimal-places.enabled", true) ? String.format("%." + CalculatorPlugin.this.config.getInt("format.decimal-places.count", 2) + "f", result) : String.valueOf(result);
                sender.sendMessage(CalculatorPlugin.this.prefix + CalculatorPlugin.this.operationColor + expression + " = " + CalculatorPlugin.this.resultColor + formattedResult);
            }
            catch (Exception e) {
                sender.sendMessage(CalculatorPlugin.this.prefix + CalculatorPlugin.this.errorColor + CalculatorPlugin.this.config.getString("messages.error", "Invalid expression: ") + e.getMessage());
                CalculatorPlugin.this.getLogger().log(Level.WARNING, "Error evaluating expression: " + expression, e);
            }
            return true;
        }

        private double evaluateWithScriptEngine(String expression) throws ScriptException {
            Object result = CalculatorPlugin.this.scriptEngine.eval(expression = expression.replace("pow", "Math.pow").replace("sin", "Math.sin").replace("cos", "Math.cos").replace("tan", "Math.tan"));
            if (result instanceof Number) {
                return ((Number)result).doubleValue();
            }
            throw new ScriptException("Expression did not evaluate to a number");
        }

        private double evaluateBasicExpression(String expression) {
            String[] parts = expression.split("\\s+");
            if (parts.length != 3) {
                throw new IllegalArgumentException("Invalid format. Use: <number> <operator> <number>");
            }
            double num1 = Double.parseDouble(parts[0]);
            String operator = parts[1];
            double num2 = Double.parseDouble(parts[2]);
            switch (operator) {
                case "+": {
                    return num1 + num2;
                }
                case "-": {
                    return num1 - num2;
                }
                case "*": {
                    return num1 * num2;
                }
                case "/": {
                    if (num2 == 0.0) {
                        throw new ArithmeticException("Division by zero");
                    }
                    return num1 / num2;
                }
                case "^": {
                    return Math.pow(num1, num2);
                }
            }
            throw new IllegalArgumentException("Unknown operator: " + operator);
        }
    }

    private class CalculatorTabCompleter
    implements TabCompleter {
        private CalculatorTabCompleter() {
        }

        public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
            ArrayList<String> suggestions = new ArrayList<String>();
            if (args.length == 1) {
                suggestions.add("1");
                suggestions.add("2");
                suggestions.add("3");
            } else if (args.length == 2) {
                suggestions.addAll(Arrays.asList("+", "-", "*", "/", "^"));
            } else if (args.length == 3) {
                suggestions.add("1");
                suggestions.add("2");
                suggestions.add("3");
            }
            return suggestions;
        }
    }
}

