/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.blocks;

import com.pedrorok.hypertube.blocks.TubeBlock;
import com.pedrorok.hypertube.blocks.blockentities.HypertubeBlockEntity;
import com.pedrorok.hypertube.core.connection.BezierConnection;
import com.pedrorok.hypertube.core.connection.SimpleConnection;
import com.pedrorok.hypertube.core.connection.interfaces.IConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnectionEntity;
import com.pedrorok.hypertube.registry.ModBlockEntities;
import com.pedrorok.hypertube.registry.ModBlocks;
import com.pedrorok.hypertube.registry.ModDataComponent;
import com.pedrorok.hypertube.utils.MessageUtils;
import com.pedrorok.hypertube.utils.RayCastUtils;
import com.pedrorok.hypertube.utils.TubeUtils;
import com.pedrorok.hypertube.utils.VoxelUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HypertubeBlock
extends TubeBlock
implements EntityBlock {
    public static final BooleanProperty CONNECTED = BooleanProperty.m_61465_((String)"connected");
    public static final BooleanProperty NORTH_SOUTH = BooleanProperty.m_61465_((String)"north_south");
    public static final BooleanProperty EAST_WEST = BooleanProperty.m_61465_((String)"east_west");
    public static final BooleanProperty UP_DOWN = BooleanProperty.m_61465_((String)"up_down");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape SHAPE_NORTH_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)11.0);
    public static final VoxelShape SHAPE_EAST_WEST = Block.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_UP_DOWN = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);

    public HypertubeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH_SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST_WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH_SOUTH, EAST_WEST, UP_DOWN, CONNECTED, WATERLOGGED});
        super.m_7926_(builder);
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        for (Direction direction : Direction.values()) {
            ITubeConnectionEntity otherTube;
            BlockPos relative = context.m_8083_().m_121945_(direction);
            BlockEntity otherEntity = context.m_43725_().m_7702_(relative);
            if (!(otherEntity instanceof ITubeConnectionEntity) || !(otherTube = (ITubeConnectionEntity)otherEntity).getFacesConnectable().contains(direction.m_122424_())) continue;
            return this.getState(state, List.of(direction), true);
        }
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        if (context.m_43723_() == null) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH_SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST_WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP_DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_192917_((Fluid)Fluids.f_76193_)));
        }
        Player player = context.m_43723_();
        Direction direction = context.m_43723_().m_6350_();
        if (player.m_146909_() < -45.0f) {
            direction = Direction.UP;
        } else if (player.m_146909_() > 45.0f) {
            direction = Direction.DOWN;
        }
        return (BlockState)this.getState(state, List.of(direction), false).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_192917_((Fluid)Fluids.f_76193_)));
    }

    @Override
    public VoxelShape getShape(BlockState state, @Nullable CollisionContext ctx) {
        EntityCollisionContext ecc;
        if (ctx instanceof EntityCollisionContext && (ecc = (EntityCollisionContext)ctx).m_193113_() != null && ecc.m_193113_().getPersistentData().m_128471_("hypertube_travel")) {
            return VoxelUtils.empty();
        }
        if (((Boolean)state.m_61143_((Property)EAST_WEST)).booleanValue()) {
            return SHAPE_EAST_WEST;
        }
        if (((Boolean)state.m_61143_((Property)UP_DOWN)).booleanValue()) {
            return SHAPE_UP_DOWN;
        }
        return SHAPE_NORTH_SOUTH;
    }

    @Override
    public Item getItem() {
        return ModBlocks.HYPERTUBE.m_5456_();
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos pos1, boolean b) {
        super.m_6861_(state, world, pos, block, pos1, b);
        BlockState newState = this.getStateFromBlockEntity(state, world, pos);
        world.m_46597_(pos, newState);
    }

    private BlockState getStateFromBlockEntity(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity be = world.m_7702_(pos);
        if (!(be instanceof HypertubeBlockEntity)) {
            return this.getState(blockState, world, pos);
        }
        HypertubeBlockEntity hypertube = (HypertubeBlockEntity)be;
        IConnection conn = hypertube.getConnectionOne();
        SimpleConnection connection = IConnection.getSameConnectionBlockPos(conn, world, pos);
        if (connection != null) {
            return this.getState(blockState, Set.of(connection.direction()), true);
        }
        conn = hypertube.getConnectionTwo();
        connection = IConnection.getSameConnectionBlockPos(conn, world, pos);
        if (connection != null) {
            return this.getState(blockState, Set.of(connection.direction()), true);
        }
        return this.getState(blockState, world, pos);
    }

    public BlockState getState(BlockState blockState, Collection<Direction> activeDirections, boolean connected) {
        if (activeDirections == null) {
            return (BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)NORTH_SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST_WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP_DOWN, (Comparable)Boolean.valueOf(false));
        }
        boolean northSouth = activeDirections.contains(Direction.NORTH) || activeDirections.contains(Direction.SOUTH);
        boolean eastWest = activeDirections.contains(Direction.EAST) || activeDirections.contains(Direction.WEST);
        boolean upDown = activeDirections.contains(Direction.UP) || activeDirections.contains(Direction.DOWN);
        return (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)NORTH_SOUTH, (Comparable)Boolean.valueOf(northSouth))).m_61124_((Property)EAST_WEST, (Comparable)Boolean.valueOf(eastWest && !northSouth))).m_61124_((Property)UP_DOWN, (Comparable)Boolean.valueOf(upDown && !northSouth && !eastWest))).m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(connected && (northSouth || eastWest || upDown)));
    }

    private BlockState getState(BlockState blockState, Level world, BlockPos pos) {
        if (blockState == null) {
            blockState = this.m_49966_();
        }
        boolean northSouth = this.isConnected((LevelAccessor)world, pos, Direction.NORTH) || this.isConnected((LevelAccessor)world, pos, Direction.SOUTH);
        boolean eastWest = this.isConnected((LevelAccessor)world, pos, Direction.EAST) || this.isConnected((LevelAccessor)world, pos, Direction.WEST);
        boolean upDown = this.isConnected((LevelAccessor)world, pos, Direction.UP) || this.isConnected((LevelAccessor)world, pos, Direction.DOWN);
        return (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)NORTH_SOUTH, (Comparable)Boolean.valueOf(northSouth))).m_61124_((Property)EAST_WEST, (Comparable)Boolean.valueOf(eastWest && !northSouth))).m_61124_((Property)UP_DOWN, (Comparable)Boolean.valueOf(upDown && !northSouth && !eastWest))).m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(northSouth || eastWest || upDown));
    }

    public void updateBlockStateFromEntity(BlockState state, Level world, BlockPos pos) {
        if (world.m_5776_()) {
            return;
        }
        BlockState newState = this.getStateFromBlockEntity(state, world, pos);
        this.updateBlockState(world, pos, newState);
    }

    public void updateBlockState(Level world, BlockPos pos, BlockState newState) {
        if (world.m_5776_()) {
            return;
        }
        BlockState currentState = world.m_8055_(pos);
        if (!currentState.equals(newState)) {
            world.m_46597_(pos, newState);
        }
    }

    @Override
    public List<Direction> getConnectedFaces(BlockState state) {
        if (!((Boolean)state.m_61143_((Property)CONNECTED)).booleanValue()) {
            return List.of();
        }
        ArrayList<Direction> directions = new ArrayList<Direction>();
        if (((Boolean)state.m_61143_((Property)NORTH_SOUTH)).booleanValue()) {
            directions.add(Direction.NORTH);
            directions.add(Direction.SOUTH);
        }
        if (((Boolean)state.m_61143_((Property)EAST_WEST)).booleanValue()) {
            directions.add(Direction.EAST);
            directions.add(Direction.WEST);
        }
        if (((Boolean)state.m_61143_((Property)UP_DOWN)).booleanValue()) {
            directions.add(Direction.UP);
            directions.add(Direction.DOWN);
        }
        return directions;
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState state) {
        return ((BlockEntityType)ModBlockEntities.HYPERTUBE.get()).m_155264_(blockPos, state);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (!(placer instanceof Player)) {
            return;
        }
        Player player = (Player)placer;
        if (level.m_5776_()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof ITubeConnectionEntity)) {
            return;
        }
        ITubeConnectionEntity thisConnection = (ITubeConnectionEntity)blockEntity;
        if (!stack.m_41790_()) {
            level.m_5594_(null, pos, this.getSoundType(state, (LevelReader)level, pos, (Entity)placer).m_56777_(), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
            return;
        }
        SimpleConnection connectionFrom = ModDataComponent.decodeSimpleConnection(stack);
        if (connectionFrom == null) {
            return;
        }
        Direction finalDirection = RayCastUtils.getDirectionFromHitResult(player, () -> state.m_60734_() instanceof ITubeConnection, true);
        SimpleConnection connectionTo = new SimpleConnection(pos, finalDirection);
        BezierConnection bezierConnection = BezierConnection.of(connectionFrom, connectionTo);
        if (!TubeUtils.checkPlayerPlacingBlockValidation(player, bezierConnection, level)) {
            level.m_245803_((Entity)placer, pos, (SoundEvent)SoundEvents.f_12209_.m_203334_(), SoundSource.BLOCKS, 1.0f, 0.5f);
            return;
        }
        BlockEntity otherBlockEntity = level.m_7702_(connectionFrom.pos());
        if (!(otherBlockEntity instanceof ITubeConnectionEntity)) {
            return;
        }
        ITubeConnectionEntity otherConnection = (ITubeConnectionEntity)otherBlockEntity;
        level.m_5594_(null, pos, this.getSoundType(state, (LevelReader)level, pos, (Entity)placer).m_56777_(), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        if (!otherConnection.hasConnectionAvailable()) {
            MessageUtils.sendActionMessage(player, (Component)Component.m_237115_((String)"placement.create_hypertube.invalid_conn").m_130940_(ChatFormatting.RED), true);
            return;
        }
        otherConnection.setConnection(bezierConnection, bezierConnection.getFromPos().direction());
        thisConnection.setConnection(connectionFrom, finalDirection);
        MessageUtils.sendActionMessage(player, (Component)Component.m_237119_(), true);
        Block block = level.m_8055_(pos).m_60734_();
        if (!(block instanceof HypertubeBlock)) {
            return;
        }
        HypertubeBlock hypertubeBlock = (HypertubeBlock)block;
        hypertubeBlock.updateBlockState(level, pos, hypertubeBlock.getState(state, List.of(finalDirection), true));
    }

    public boolean m_7420_(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return true;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (context.m_43725_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (context.m_43723_() == null) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (((Boolean)state.m_61143_((Property)CONNECTED)).booleanValue()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ITubeConnectionEntity) {
                ITubeConnectionEntity tube = (ITubeConnectionEntity)blockEntity;
                tube.wrenchClicked(context.m_43719_());
            }
            this.updateAfterWrenched(state, context);
            this.playRotateSound(context.m_43725_(), context.m_8083_());
            return InteractionResult.SUCCESS;
        }
        state = (Boolean)state.m_61143_((Property)EAST_WEST) != false ? (BlockState)((BlockState)state.m_61124_((Property)EAST_WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP_DOWN, (Comparable)Boolean.valueOf(true)) : ((Boolean)state.m_61143_((Property)UP_DOWN) != false ? (BlockState)((BlockState)state.m_61124_((Property)UP_DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH_SOUTH, (Comparable)Boolean.valueOf(true)) : ((Boolean)state.m_61143_((Property)NORTH_SOUTH) != false ? (BlockState)((BlockState)state.m_61124_((Property)NORTH_SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST_WEST, (Comparable)Boolean.valueOf(true)) : this.getState(state, List.of(context.m_43719_()), false)));
        level.m_5594_(player, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 0.75f, 1.0f);
        return super.onWrenched(state, context);
    }
}

