/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.blocks.blockentities;

import com.pedrorok.hypertube.HypertubeMod;
import com.pedrorok.hypertube.blocks.HyperEntranceBlock;
import com.pedrorok.hypertube.blocks.blockentities.ActionTubeBlockEntity;
import com.pedrorok.hypertube.config.ServerConfig;
import com.pedrorok.hypertube.core.connection.TubeConnectionException;
import com.pedrorok.hypertube.core.connection.interfaces.IConnection;
import com.pedrorok.hypertube.core.sound.TubeSoundManager;
import com.pedrorok.hypertube.core.travel.TravelManager;
import com.pedrorok.hypertube.utils.TubeUtils;
import com.simibubi.create.content.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.kinetics.base.IRotate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HyperEntranceBlockEntity
extends ActionTubeBlockEntity
implements IHaveHoveringInformation {
    private IConnection connection;

    public HyperEntranceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (compound.m_128441_("Connection")) {
            this.connection = this.getConnection(compound, "Connection");
        }
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.writeConnection(compound, new Tuple[]{new Tuple((Object)this.connection, (Object)"Connection")});
    }

    @Override
    public boolean wrenchClicked(Direction direction) {
        IConnection connectionInDirection = this.getConnectionInDirection(direction);
        if (connectionInDirection == null) {
            return false;
        }
        connectionInDirection.updateTubeSegments(this.f_58857_);
        return true;
    }

    public void tick() {
        boolean canOpen;
        super.tick();
        Boolean isBlocked = (Boolean)this.m_58900_().m_61143_((Property)HyperEntranceBlock.IN_FRONT);
        if (this.f_58857_.f_46443_) {
            this.tickClient(isBlocked);
            return;
        }
        if (isBlocked.booleanValue()) {
            return;
        }
        BlockState state = this.m_58900_();
        BlockPos pos = this.m_58899_();
        float actualSpeed = Math.abs(this.getSpeed());
        Boolean isOpen = (Boolean)state.m_61143_((Property)HyperEntranceBlock.OPEN);
        if (actualSpeed < 16.0f) {
            if (isOpen.booleanValue()) {
                this.f_58857_.m_7731_(pos, (BlockState)state.m_61124_((Property)HyperEntranceBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
                this.playOpenCloseSound(false);
            }
            return;
        }
        boolean isNotLocked = (Boolean)this.m_58900_().m_61143_((Property)HyperEntranceBlock.LOCKED) == false;
        LivingEntity nearbyEntity = this.getNearbyLivingEntities((ServerLevel)this.f_58857_, pos.m_252807_());
        boolean bl = canOpen = nearbyEntity != null && (isNotLocked || nearbyEntity.m_6144_() || nearbyEntity.getPersistentData().m_128471_("hypertube_travel"));
        if (this.isTubeClosed(canOpen, isOpen)) {
            return;
        }
        LivingEntity inRangeEntity = this.getInRangeLivingEntities((ServerLevel)this.f_58857_, pos.m_252807_(), (Direction)state.m_61143_((Property)HyperEntranceBlock.FACING));
        if (inRangeEntity == null) {
            return;
        }
        if (isNotLocked && inRangeEntity.m_6144_() && !inRangeEntity.getPersistentData().m_128471_("hypertube_travel")) {
            return;
        }
        TravelManager.tryStartTravel(inRangeEntity, pos, state, TubeUtils.calculateTravelSpeed(actualSpeed));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickClient(boolean isBlocked) {
        float actualSpeed = Math.abs(this.getSpeed());
        TubeSoundManager.TubeAmbientSound sound = TubeSoundManager.getAmbientSound(this.tubeSoundId);
        if (actualSpeed < 16.0f || isBlocked) {
            sound.tickClientPlayerSounds();
            return;
        }
        this.playClientEffects(sound);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        float finalSpeed = Math.abs(this.getSpeed());
        IRotate.SpeedLevel.getFormattedSpeedText((float)this.speed, (finalSpeed < 16.0f ? 1 : 0) != 0).forGoggles(tooltip);
        if (((Boolean)this.m_58900_().m_61143_((Property)HyperEntranceBlock.IN_FRONT)).booleanValue()) {
            tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_((Component)Component.m_237115_((String)"tooltip.create_hypertube.entrance_blocked").m_130940_(ChatFormatting.RED)));
        } else if (finalSpeed < 16.0f) {
            tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_((Component)Component.m_237113_((String)"\u2592 ")).m_7220_((Component)Component.m_237115_((String)"tooltip.create_hypertube.entrance_no_speed")).m_130940_(ChatFormatting.RED));
        }
        return true;
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (((Boolean)this.m_58900_().m_61143_((Property)HyperEntranceBlock.LOCKED)).booleanValue() && Math.abs(this.getSpeed()) >= 16.0f) {
            tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_((Component)Component.m_237115_((String)"block.hypertube.hyper_entrance.sneak_to_enter")).m_130940_(ChatFormatting.WHITE));
        }
        return true;
    }

    @Override
    public void setConnection(IConnection connection, Direction thisConnectionDir) {
        if (this.connection != null) {
            HypertubeMod.LOGGER.error(new TubeConnectionException("Connection could not define connection", this.connection, connection).getMessage());
            return;
        }
        this.connection = connection;
        this.m_6596_();
        this.sync();
    }

    @Override
    public void clearConnection(IConnection connection) {
        if (this.connection == null || !this.connection.isSameConnection(connection)) {
            HypertubeMod.LOGGER.error(new TubeConnectionException("Connection could not be cleared", this.connection, connection).getMessage());
            return;
        }
        this.connection = null;
        this.m_6596_();
        this.sync();
    }

    @Override
    public List<Direction> getFacesConnectable() {
        if (this.connection != null) {
            return List.of();
        }
        return List.of((Direction)this.m_58900_().m_61143_((Property)HyperEntranceBlock.FACING));
    }

    @Override
    public List<IConnection> getConnections() {
        ArrayList<IConnection> connections = new ArrayList<IConnection>();
        if (this.connection != null) {
            connections.add(this.connection);
        }
        return connections;
    }

    @Override
    public Vec3 getExitDirection() {
        if (this.m_58900_().m_61138_((Property)HyperEntranceBlock.FACING)) {
            Direction facing = ((Direction)this.m_58900_().m_61143_((Property)HyperEntranceBlock.FACING)).m_122424_();
            return Vec3.m_82528_((Vec3i)facing.m_122436_());
        }
        return null;
    }

    @Override
    protected int getConnectionCount() {
        return 1;
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = ((Double)ServerConfig.get().STRESS_IMPACT_ENTRANCE.get()).floatValue();
        return impact;
    }

    public IConnection getConnection() {
        return this.connection;
    }
}

