/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.client.renderer;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.pedrorok.hypertube.blocks.HyperAcceleratorBlock;
import com.pedrorok.hypertube.blocks.blockentities.HyperAcceleratorBlockEntity;
import com.pedrorok.hypertube.client.BezierTextureRenderer;
import com.pedrorok.hypertube.core.connection.BezierConnection;
import com.pedrorok.hypertube.core.connection.interfaces.IConnection;
import com.pedrorok.hypertube.registry.ModPartialModels;
import com.pedrorok.hypertube.utils.RenderUtils;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class AcceleratorEntityRenderer
extends KineticBlockEntityRenderer<HyperAcceleratorBlockEntity> {
    private final BezierTextureRenderer tubeRenderer = BezierTextureRenderer.get();

    public AcceleratorEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(HyperAcceleratorBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = be.m_58900_();
        if (!(blockState.m_60734_() instanceof HyperAcceleratorBlock)) {
            return;
        }
        Direction facing = (Direction)blockState.m_61143_((Property)HyperAcceleratorBlock.FACING);
        boolean isTubeOnVertical = facing.m_122434_().m_122478_();
        be.getTubeAttachments().forEach((direct, attachment) -> {
            SuperByteBuffer smartTubeModel = CachedBufferer.partial((PartialModel)attachment.getPartialModel(blockState, be, (Direction)direct), (BlockState)blockState);
            RenderUtils.rotateToFace(smartTubeModel, facing, direct.m_122424_(), isTubeOnVertical);
            smartTubeModel.light(light);
            smartTubeModel.renderInto(ms, buffer.m_6299_(RenderType.m_110466_()));
        });
        SuperByteBuffer cogwheelModel = CachedBufferer.partialFacingVertical((PartialModel)ModPartialModels.COGWHEEL_HOLE, (BlockState)blockState, (Direction)facing);
        float angle = AcceleratorEntityRenderer.getAngleForTe((KineticBlockEntity)be, (BlockPos)be.m_58899_(), (Direction.Axis)facing.m_122434_());
        Direction.Axis rotationAxisOf = AcceleratorEntityRenderer.getRotationAxisOf((KineticBlockEntity)be);
        AcceleratorEntityRenderer.kineticRotationTransform((SuperByteBuffer)cogwheelModel, (KineticBlockEntity)be, (Direction.Axis)rotationAxisOf, (float)angle, (int)light);
        cogwheelModel.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        IConnection iConnection = be.getConnectionOne();
        if (iConnection instanceof BezierConnection) {
            BezierConnection bezierConnectionOne = (BezierConnection)iConnection;
            this.tubeRenderer.renderBezierConnection(be.m_58899_(), bezierConnectionOne, ms, buffer, light, overlay);
        }
        if ((iConnection = be.getConnectionTwo()) instanceof BezierConnection) {
            BezierConnection bezierConnectionTwo = (BezierConnection)iConnection;
            this.tubeRenderer.renderBezierConnection(be.m_58899_(), bezierConnectionTwo, ms, buffer, light, overlay);
        }
    }

    public boolean shouldRenderOffScreen(HyperAcceleratorBlockEntity p_112306_) {
        return true;
    }

    public boolean shouldRender(HyperAcceleratorBlockEntity p_173568_, Vec3 p_173569_) {
        return true;
    }
}

