/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.client.renderer;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.pedrorok.hypertube.blocks.HyperEntranceBlock;
import com.pedrorok.hypertube.blocks.blockentities.HyperEntranceBlockEntity;
import com.pedrorok.hypertube.client.BezierTextureRenderer;
import com.pedrorok.hypertube.core.connection.BezierConnection;
import com.pedrorok.hypertube.core.connection.interfaces.IConnection;
import com.pedrorok.hypertube.registry.ModPartialModels;
import com.pedrorok.hypertube.utils.RenderUtils;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class EntranceBlockEntityRenderer
extends KineticBlockEntityRenderer<HyperEntranceBlockEntity> {
    private final BezierTextureRenderer tubeRenderer = BezierTextureRenderer.get();

    public EntranceBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(HyperEntranceBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = be.m_58900_();
        if (!(blockState.m_60734_() instanceof HyperEntranceBlock)) {
            return;
        }
        Direction facing = (Direction)blockState.m_61143_((Property)HyperEntranceBlock.FACING);
        boolean isTubeOnVertical = facing.m_122434_().m_122478_();
        be.getTubeAttachments().forEach((direct, attachment) -> {
            SuperByteBuffer smartTubeModel = CachedBufferer.partial((PartialModel)attachment.getPartialModel(blockState, be, (Direction)direct), (BlockState)blockState);
            RenderUtils.rotateToFace(smartTubeModel, facing, direct.m_122424_(), isTubeOnVertical);
            smartTubeModel.light(light);
            smartTubeModel.renderInto(ms, buffer.m_6299_(RenderType.m_110466_()));
        });
        SuperByteBuffer cogwheelModel = CachedBufferer.partialFacingVertical((PartialModel)ModPartialModels.COGWHEEL_HOLE, (BlockState)blockState, (Direction)facing);
        float angle = EntranceBlockEntityRenderer.getAngleForTe((KineticBlockEntity)be, (BlockPos)be.m_58899_(), (Direction.Axis)facing.m_122434_());
        Direction.Axis rotationAxisOf = EntranceBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)be);
        EntranceBlockEntityRenderer.kineticRotationTransform((SuperByteBuffer)cogwheelModel, (KineticBlockEntity)be, (Direction.Axis)rotationAxisOf, (float)angle, (int)light);
        cogwheelModel.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        IConnection iConnection = be.getConnection();
        if (iConnection instanceof BezierConnection) {
            BezierConnection bezierConnection = (BezierConnection)iConnection;
            this.tubeRenderer.renderBezierConnection(be.m_58899_(), bezierConnection, ms, buffer, light, overlay);
        }
    }

    public boolean shouldRenderOffScreen(HyperEntranceBlockEntity p_112306_) {
        return true;
    }

    public boolean shouldRender(HyperEntranceBlockEntity p_173568_, Vec3 p_173569_) {
        return true;
    }
}

