/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.core.smarttube;

import com.pedrorok.hypertube.blocks.blockentities.ActionTubeBlockEntity;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeActionPoint;
import com.pedrorok.hypertube.core.smarttube.RedstoneDetectorAttachment;
import com.pedrorok.hypertube.core.smarttube.TubeScannerAttachment;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ITubeAttachment {
    public static final Map<String, ITubeAttachment> REGISTRY = new HashMap<String, ITubeAttachment>();

    public String getId();

    default public ITubeActionPoint getActionPoint(Direction attachedDirection) {
        return null;
    }

    default public boolean emitRedstoneSignal() {
        return false;
    }

    public PartialModel getPartialModel(BlockState var1, ActionTubeBlockEntity var2, Direction var3);

    public ItemStack getItemStack();

    public static void register(@NotNull ITubeAttachment smartTube) {
        if (REGISTRY.containsKey(smartTube.getId())) {
            throw new IllegalArgumentException("Duplicate smart tube ID: " + smartTube.getId());
        }
        REGISTRY.put(smartTube.getId(), smartTube);
    }

    @Nullable
    public static ITubeAttachment get(String id) {
        return REGISTRY.get(id);
    }

    public static void init() {
        ITubeAttachment.register(new RedstoneDetectorAttachment());
        ITubeAttachment.register(new TubeScannerAttachment());
    }
}

