/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.network.packets;

import com.pedrorok.hypertube.HypertubeMod;
import com.pedrorok.hypertube.network.Packet;
import com.simibubi.create.foundation.networking.ISyncPersistentData;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public record SyncPersistentDataPacket(int entityId, CompoundTag readData) implements Packet<SyncPersistentDataPacket>
{
    public SyncPersistentDataPacket(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.m_130260_());
    }

    public static SyncPersistentDataPacket create(Entity entity) {
        return new SyncPersistentDataPacket(entity.m_19879_(), entity.getPersistentData());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(SyncPersistentDataPacket packet) {
        try {
            Entity entityByID = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityId);
            if (entityByID == null) {
                return;
            }
            CompoundTag data = entityByID.getPersistentData();
            new HashSet(data.m_128431_()).forEach(arg_0 -> ((CompoundTag)data).m_128473_(arg_0));
            data.m_128391_(packet.readData);
            if (!(entityByID instanceof ISyncPersistentData)) {
                return;
            }
            ((ISyncPersistentData)entityByID).onPersistentDataUpdated();
        }
        catch (Exception e) {
            HypertubeMod.LOGGER.error("Failed to handle SyncPersistentDataPacket for entity ID: {}", (Object)packet.entityId, (Object)e);
        }
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.m_130079_(this.readData);
    }

    @Override
    public void execute(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> SyncPersistentDataPacket.handleClient(this));
        ctx.get().setPacketHandled(true);
    }
}

