/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.blocks;

import com.pedrorok.hypertube.blocks.ActionTubeBlock;
import com.pedrorok.hypertube.blocks.blockentities.ActionTubeBlockEntity;
import com.pedrorok.hypertube.blocks.blockentities.HyperEntranceBlockEntity;
import com.pedrorok.hypertube.registry.ModBlockEntities;
import com.pedrorok.hypertube.registry.ModBlocks;
import com.pedrorok.hypertube.utils.MessageUtils;
import com.pedrorok.hypertube.utils.VoxelUtils;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HyperEntranceBlock
extends ActionTubeBlock
implements EntityBlock,
ICogWheel {
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty LOCKED = BlockStateProperties.f_61444_;
    public static final BooleanProperty IN_FRONT = BooleanProperty.m_61465_((String)"has_block_in_front");
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)23.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)-7.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)-7.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)23.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_UP = Block.m_49796_((double)0.0, (double)-7.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)23.0, (double)16.0);

    public HyperEntranceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)IN_FRONT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, IN_FRONT, LOCKED, WATERLOGGED, POWER, POWERED});
        super.m_7926_(builder);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        if (player == null) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_().m_122424_())).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_192917_((Fluid)Fluids.f_76193_)));
        }
        Direction direction = player.m_6350_();
        if (player.m_146909_() < -45.0f) {
            direction = Direction.UP;
        } else if (player.m_146909_() > 45.0f) {
            direction = Direction.DOWN;
        }
        boolean isFrontBlocked = false;
        BlockPos relative = context.m_8083_().m_121945_(direction.m_122424_());
        if (!level.m_8055_(relative).m_60812_((BlockGetter)level, relative).m_83281_()) {
            isFrontBlocked = true;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)IN_FRONT, (Comparable)Boolean.valueOf(isFrontBlocked))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_192917_((Fluid)Fluids.f_76193_)));
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, level, pos, neighbor);
        this.updateInFrontProperty((Level)level, pos, state);
    }

    public void updateInFrontProperty(Level level, BlockPos pos, BlockState state) {
        boolean isFrontBlocked = false;
        Direction facing = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
        BlockPos relative = pos.m_121945_(facing);
        if (!level.m_8055_(relative).m_60812_((BlockGetter)level, relative).m_83281_()) {
            isFrontBlocked = true;
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)IN_FRONT, (Comparable)Boolean.valueOf(isFrontBlocked)), 3);
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_();
    }

    @Override
    public Item getItem() {
        return ModBlocks.HYPERTUBE_ENTRANCE.m_5456_();
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return ((BlockEntityType)ModBlockEntities.HYPERTUBE_ENTRANCE.get()).m_155264_(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return (level1, pos, state1, be) -> ((ActionTubeBlockEntity)be).tick();
    }

    @Override
    public boolean canTravelConnect(LevelAccessor world, BlockPos pos, Direction facing) {
        BlockState state = world.m_8055_(pos);
        return facing.m_122424_() == state.m_61143_((Property)FACING) && state.m_60734_() instanceof HyperEntranceBlock;
    }

    @Override
    public List<Direction> getConnectedFaces(BlockState state) {
        return List.of(((Direction)state.m_61143_((Property)FACING)).m_122424_());
    }

    @Override
    public VoxelShape getShape(BlockState state, @Nullable CollisionContext ctx) {
        EntityCollisionContext ecc;
        if (ctx instanceof EntityCollisionContext && (ecc = (EntityCollisionContext)ctx).m_193113_() != null && ecc.m_193113_().getPersistentData().m_128471_("hypertube_travel")) {
            return VoxelUtils.empty();
        }
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.UP -> SHAPE_UP;
            case Direction.DOWN -> SHAPE_DOWN;
            default -> SHAPE_NORTH;
        };
    }

    public boolean isSmallCog() {
        return true;
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        HyperEntranceBlockEntity entrance;
        if (context.m_43725_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (super.onWrenched(state, context) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = context.m_43725_().m_7702_(context.m_8083_());
        if (blockEntity instanceof HyperEntranceBlockEntity && (entrance = (HyperEntranceBlockEntity)blockEntity).wrenchClicked(context.m_43719_())) {
            IWrenchable.playRotateSound((Level)context.m_43725_(), (BlockPos)context.m_8083_());
            return InteractionResult.SUCCESS;
        }
        Player player = context.m_43723_();
        BlockState blockState = (BlockState)state.m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)LOCKED) == false));
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        level.m_7731_(pos, blockState, 3);
        if (((Boolean)blockState.m_61143_((Property)LOCKED)).booleanValue()) {
            MessageUtils.sendActionMessage(player, (Component)Component.m_237115_((String)"block.hypertube.hyper_entrance.manual_lock").m_130946_(" (").m_7220_((Component)Component.m_237115_((String)"block.hypertube.hyper_entrance.sneak_to_enter")).m_130946_(")").m_130940_(ChatFormatting.GOLD), true);
        } else {
            MessageUtils.sendActionMessage(player, (Component)Component.m_237115_((String)"block.hypertube.hyper_entrance.automatic_lock").m_130940_(ChatFormatting.GREEN), true);
        }
        IWrenchable.playRotateSound((Level)context.m_43725_(), (BlockPos)context.m_8083_());
        return InteractionResult.SUCCESS;
    }

    @Override
    protected BooleanProperty propertyToUpdate() {
        return LOCKED;
    }
}

