/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.core.travel;

import com.pedrorok.hypertube.HypertubeMod;
import com.pedrorok.hypertube.blocks.HyperEntranceBlock;
import com.pedrorok.hypertube.config.ClientConfig;
import com.pedrorok.hypertube.core.sound.TubeSoundManager;
import com.pedrorok.hypertube.core.travel.TravelPathData;
import com.pedrorok.hypertube.core.travel.TravelPathMover;
import com.pedrorok.hypertube.events.PlayerSyncEvents;
import com.pedrorok.hypertube.network.NetworkHandler;
import com.pedrorok.hypertube.network.packets.MovePathPacket;
import com.pedrorok.hypertube.network.packets.SyncPersistentDataPacket;
import com.pedrorok.hypertube.utils.MessageUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class TravelManager {
    private static final Object2ObjectArrayMap<UUID, TravelPathMover> travelDataMap = new Object2ObjectArrayMap();
    private static boolean isTraveling;

    public static void tryStartTravel(LivingEntity entity, BlockPos pos, BlockState state, float speed) {
        BlockPos relative;
        TravelPathData travelPathData;
        BlockPos lastTravelPos;
        CompoundTag entityPersistentData = entity.getPersistentData();
        if (entityPersistentData.m_128471_("hypertube_travel")) {
            return;
        }
        boolean isPlayer = entity instanceof ServerPlayer;
        ServerPlayer player = isPlayer ? (ServerPlayer)entity : null;
        long lastTravelTime = entityPersistentData.m_128454_("last_travel_time");
        if (entityPersistentData.m_128441_("last_travel_blockpos") && (lastTravelPos = BlockPos.m_122022_((long)entityPersistentData.m_128454_("last_travel_blockpos"))).equals((Object)pos) && lastTravelTime > System.currentTimeMillis()) {
            return;
        }
        if (lastTravelTime - 1500L > System.currentTimeMillis()) {
            speed += entityPersistentData.m_128457_("last_travel_speed");
        }
        if ((travelPathData = new TravelPathData(relative = pos.m_121945_((Direction)state.m_61143_((Property)HyperEntranceBlock.FACING)), entity.m_9236_(), pos)).getTravelPoints().size() < 3) {
            if (!isPlayer) {
                return;
            }
            MessageUtils.sendActionMessage((Player)player, (Component)Component.m_237115_((String)"hypertube.travel.too_short").m_130940_(ChatFormatting.RED), true);
            return;
        }
        entityPersistentData.m_128379_("hypertube_travel", true);
        float finalSpeed = speed * 1.0f;
        TravelPathMover pathMover = new TravelPathMover(pos, entity, travelPathData.getTravelPoints(), travelPathData.getActionPoints(), finalSpeed, travelPathData.getEndDirection(entity.m_9236_()), travelPathData.getLastBlockPos(), TravelManager::finishTravel);
        travelDataMap.put((Object)entity.m_20148_(), (Object)pathMover);
        MovePathPacket movePathPacket = new MovePathPacket(entity.m_19879_(), travelPathData.getTravelPoints(), travelPathData.getActionPoints(), finalSpeed);
        NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)movePathPacket);
        Vec3 center = pos.m_252807_();
        TubeSoundManager.playTubeSuctionSound(entity, center);
        TravelManager.syncPersistentData(entity);
        HypertubeMod.LOGGER.debug("Travel started: {} to {} and speed {}", (Object)entity.m_7755_().getString(), (Object)relative, (Object)Float.valueOf(pathMover.getTravelSpeed()));
    }

    public static void entityTick(LivingEntity entity) {
        TravelManager.handleCommon(entity);
        if (entity.m_9236_().f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            TravelManager.clientTick(player);
            return;
        }
        if (entity.m_9236_().f_46443_) {
            return;
        }
        TravelManager.handleServer(entity);
    }

    private static void handleCommon(LivingEntity entity) {
        if (TravelManager.hasHyperTubeData((Entity)entity)) {
            entity.m_6210_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void clientTick(Player player) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (!mc.f_91074_.m_7306_((Entity)player)) {
            return;
        }
        if (TravelManager.hasHyperTubeData((Entity)player)) {
            TubeSoundManager.TravelSound.enableClientPlayerSound((Entity)player, 0.8f, 1.0f);
            isTraveling = true;
            return;
        }
        if (isTraveling && !((Boolean)ClientConfig.get().ALLOW_FPV_INSIDE_TUBE.get()).booleanValue()) {
            Minecraft.m_91087_().f_91066_.m_92157_(CameraType.FIRST_PERSON);
            isTraveling = false;
        }
    }

    public static void finishTravel(ServerPlayer player) {
        if (!travelDataMap.containsKey((Object)player.m_20148_())) {
            return;
        }
        TravelManager.finishTravel((LivingEntity)player, true);
    }

    private static void finishTravel(LivingEntity entity, boolean forced) {
        Level level = entity.m_9236_();
        TravelPathMover pathMover = (TravelPathMover)travelDataMap.get((Object)entity.m_20148_());
        travelDataMap.remove((Object)entity.m_20148_());
        TravelManager.removeDismountedData(entity);
        entity.getPersistentData().m_128379_("hypertube_travel", false);
        entity.getPersistentData().m_128356_("last_travel_time", System.currentTimeMillis() + 2000L);
        entity.getPersistentData().m_128356_("last_travel_blockpos", pathMover.getLastPos().m_121878_());
        float finalSpeed = pathMover.getTravelSpeed();
        entity.getPersistentData().m_128350_("last_travel_speed", finalSpeed);
        entity.getPersistentData().m_128379_("hypertube_immunity", true);
        TravelManager.syncPersistentData(entity);
        Vec3 lastDir = pathMover.getLastDir();
        Vec3 lastBlockPos = pathMover.getLastPos().m_252807_();
        BlockState blockState = level.m_8055_(BlockPos.m_274446_((Position)lastBlockPos));
        if (blockState.m_60734_() instanceof HyperEntranceBlock) {
            lastBlockPos = pathMover.getLastPos().m_121945_(((Direction)blockState.m_61143_((Property)HyperEntranceBlock.FACING)).m_122424_()).m_252807_();
        }
        if (!forced) {
            if (level instanceof ServerLevel) {
                entity.m_6021_(lastBlockPos.f_82479_, lastBlockPos.f_82480_, lastBlockPos.f_82481_);
            }
            entity.m_20256_(lastDir.m_82490_((double)Math.max(finalSpeed, 1.0f)));
        }
        entity.f_19864_ = true;
        entity.m_20124_(Pose.SWIMMING);
        TubeSoundManager.playTubeSuctionSound(entity, entity.m_20182_());
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        player.m_36320_();
    }

    private static void removeDismountedData(LivingEntity entity) {
        CompoundTag forgeData;
        CompoundTag persistentData = entity.getPersistentData();
        if (persistentData.m_128425_("ForgeData", 10) && (forgeData = persistentData.m_128469_("ForgeData")).m_128441_("ContraptionDismountLocation")) {
            forgeData.m_128473_("ContraptionDismountLocation");
            persistentData.m_128365_("ForgeData", (Tag)forgeData);
        }
    }

    public static void finishTravel(UUID entityUuid) {
        TravelPathMover pathMover = (TravelPathMover)travelDataMap.get((Object)entityUuid);
        if (pathMover == null) {
            return;
        }
        pathMover.setClientFinish();
    }

    public static void actionPointReach(UUID entityUuid, BlockPos blockPos) {
        TravelPathMover pathMover = (TravelPathMover)travelDataMap.get((Object)entityUuid);
        if (pathMover == null) {
            return;
        }
        pathMover.handleActionPoint(blockPos);
    }

    private static void handleServer(LivingEntity entity) {
        if (!travelDataMap.containsKey((Object)entity.m_20148_())) {
            if (!entity.getPersistentData().m_128471_("hypertube_travel")) {
                return;
            }
            entity.getPersistentData().m_128379_("hypertube_travel", false);
            return;
        }
        TravelPathMover travelPathData = (TravelPathMover)travelDataMap.get((Object)entity.m_20148_());
        entity.m_183634_();
        travelPathData.tickEntity(entity);
    }

    public static boolean hasHyperTubeData(Entity entity) {
        return entity.getPersistentData().m_128471_("hypertube_travel");
    }

    private static void syncPersistentData(LivingEntity entity) {
        PlayerSyncEvents.syncPlayerStateToAll(entity, true);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            NetworkHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SyncPersistentDataPacket(player.m_19879_(), player.getPersistentData()));
        }
    }
}

