/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.core.travel;

import com.pedrorok.hypertube.blocks.blockentities.ActionTubeBlockEntity;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeActionPoint;
import com.pedrorok.hypertube.network.NetworkHandler;
import com.pedrorok.hypertube.network.packets.EntityTravelDirDataPacket;
import com.pedrorok.hypertube.network.packets.SyncEntityPosPacket;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class TravelPathMover {
    private final List<Vec3> pathPoints;
    private final Set<BlockPos> actionPoints;
    private final Set<BlockPos> activeActionPoints;
    private float travelSpeed;
    private final BiConsumer<LivingEntity, Boolean> onFinishCallback;
    private final BlockPos lastPos;
    private int currentSegment = 0;
    private Vec3 currentStart;
    private Vec3 currentEnd;
    private double totalDistance;
    private double traveled;
    private final LivingEntity entity;
    private Vec3 lastDirection;

    public TravelPathMover(final BlockPos firstBlockEntrance, LivingEntity entity, List<Vec3> points, Set<BlockPos> actionPoints, float travelSpeed, Vec3 lastDirection, BlockPos lastPos, BiConsumer<LivingEntity, Boolean> onFinishCallback) {
        this.entity = entity;
        this.pathPoints = points;
        this.actionPoints = actionPoints;
        this.activeActionPoints = new HashSet<BlockPos>(){
            {
                this.add(firstBlockEntrance);
            }
        };
        actionPoints.add(lastPos);
        this.travelSpeed = travelSpeed;
        this.lastPos = lastPos;
        this.currentStart = entity.m_20182_();
        this.currentEnd = this.pathPoints.get(0).m_82492_(0.0, 0.25, 0.0);
        this.totalDistance = this.currentStart.m_82554_(this.currentEnd);
        this.traveled = 0.0;
        this.onFinishCallback = onFinishCallback;
        this.lastDirection = lastDirection;
        if (lastDirection != null) {
            return;
        }
        this.lastDirection = this.pathPoints.get(this.pathPoints.size() - 1).m_82546_(this.pathPoints.get(this.pathPoints.size() - 2)).m_82541_();
    }

    public void tickEntity(LivingEntity entity) {
        if (entity.m_5833_() || !entity.m_6084_()) {
            this.onFinishCallback.accept(entity, true);
            return;
        }
        if (this.traveled >= this.totalDistance) {
            ++this.currentSegment;
            if (this.currentSegment >= this.pathPoints.size()) {
                this.onFinishCallback.accept(entity, false);
                return;
            }
            this.currentStart = this.currentEnd;
            this.currentEnd = this.pathPoints.get(this.currentSegment).m_82492_(0.0, 0.25, 0.0);
            this.totalDistance = this.currentStart.m_82554_(this.currentEnd);
            this.traveled = 0.0;
        }
        if (!this.activeActionPoints.isEmpty()) {
            ActionTubeBlockEntity actionTubeBlockEntity;
            BlockEntity be;
            BlockPos actionPos = this.activeActionPoints.iterator().next();
            this.activeActionPoints.remove(actionPos);
            Block block = entity.m_9236_().m_8055_(actionPos).m_60734_();
            if (block instanceof ITubeActionPoint) {
                ITubeActionPoint travelAction = (ITubeActionPoint)block;
                travelAction.handleTravelPath(entity, this, actionPos);
            }
            if ((be = entity.m_9236_().m_7702_(actionPos)) instanceof ActionTubeBlockEntity && (actionTubeBlockEntity = (ActionTubeBlockEntity)be).hasAnyTubeAttachment()) {
                actionTubeBlockEntity.activateAllTubeAttachments(entity, this, actionPos);
            }
        }
        Vec3 direction = this.currentEnd.m_82546_(this.currentStart).m_82541_().m_82490_((double)this.travelSpeed);
        Vec3 newPos = entity.m_20182_().m_82549_(direction);
        entity.m_6027_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        this.traveled += (double)this.travelSpeed;
        entity.m_183634_();
        TravelPathMover.handleEntityDirection(entity, direction);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_21255_()) {
                player.m_36321_();
            }
            return;
        }
        NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)SyncEntityPosPacket.create((Entity)entity, this.currentSegment));
    }

    public void handleActionPoint(BlockPos actionPos) {
        this.activeActionPoints.add(actionPos);
        this.actionPoints.remove(actionPos);
    }

    private static void handleEntityDirection(LivingEntity entity, Vec3 direction) {
        float yaw = (float)Math.toDegrees(Math.atan2(-direction.f_82479_, direction.f_82481_));
        float pitch = (float)Math.toDegrees(Math.atan2(-direction.f_82480_, Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_)));
        entity.m_146922_(yaw);
        entity.m_146926_(pitch);
        if (entity.m_9236_().f_46443_) {
            return;
        }
        NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)EntityTravelDirDataPacket.create((Entity)entity));
    }

    public Vec3 getLastDir() {
        return this.lastDirection;
    }

    public void setClientFinish() {
        this.onFinishCallback.accept(this.entity, false);
    }

    public float getTravelSpeed() {
        return this.travelSpeed;
    }

    public void setTravelSpeed(float travelSpeed) {
        this.travelSpeed = travelSpeed;
    }

    public BlockPos getLastPos() {
        return this.lastPos;
    }
}

