/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.suggestionz;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class SuggestionZ
extends JavaPlugin {
    private File suggestionsFile;
    private FileConfiguration suggestionsConfig;
    private List<String> defaultTopics;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.suggestionsFile = new File(this.getDataFolder(), "suggestions.yml");
        if (!this.suggestionsFile.exists()) {
            if (!this.getDataFolder().exists()) {
                this.getDataFolder().mkdirs();
            }
            try {
                this.suggestionsFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Could not create suggestions.yml file!");
                e.printStackTrace();
            }
        }
        this.suggestionsConfig = YamlConfiguration.loadConfiguration(this.suggestionsFile);
        this.getCommand("suggest").setExecutor(new SuggestCommand());
        this.getCommand("idealist").setExecutor(new IdeaListCommand());
        this.getCommand("managetopics").setExecutor(new ManageTopicsCommand());
        this.defaultTopics = this.getConfig().getStringList("default-topics");
        if (this.defaultTopics.isEmpty()) {
            this.defaultTopics.add("gameplay");
            this.defaultTopics.add("building");
            this.defaultTopics.add("events");
            this.defaultTopics.add("server");
            this.defaultTopics.add("other");
            this.getConfig().set("default-topics", this.defaultTopics);
            this.saveConfig();
        }
        if (!this.suggestionsConfig.isConfigurationSection("suggestions")) {
            this.suggestionsConfig.createSection("suggestions");
            this.saveSuggestionsConfig();
        }
        if (!this.suggestionsConfig.isConfigurationSection("cooldowns")) {
            this.suggestionsConfig.createSection("cooldowns");
            this.saveSuggestionsConfig();
        }
        this.getLogger().info("SuggestionZ has been enabled!");
    }

    @Override
    public void onDisable() {
        if (this.suggestionsConfig != null) {
            this.saveSuggestionsConfig();
        }
        this.getLogger().info("SuggestionZ has been disabled!");
    }

    public void saveSuggestionsConfig() {
        try {
            this.suggestionsConfig.save(this.suggestionsFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save suggestions file!");
            e.printStackTrace();
        }
    }

    private String colorize(String message) {
        if (message == null) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes('&', message);
    }

    private class SuggestCommand
    implements CommandExecutor {
        private SuggestCommand() {
        }

        @Override
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            String suggestion;
            if (!(sender instanceof Player)) {
                sender.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.player-only")));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("suggestionz.suggest")) {
                player.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.no-permission")));
                return true;
            }
            if (args.length < 1) {
                player.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.suggest-usage")));
                return true;
            }
            String topic = "other";
            if (args.length >= 2 && this.isValidTopic(args[0])) {
                topic = args[0].toLowerCase();
                sb = new StringBuilder();
                for (int i = 1; i < args.length; ++i) {
                    sb.append(args[i]).append(" ");
                }
                suggestion = sb.toString().trim();
            } else {
                sb = new StringBuilder();
                for (String arg : args) {
                    sb.append(arg).append(" ");
                }
                suggestion = sb.toString().trim();
            }
            int cooldownSeconds = SuggestionZ.this.getConfig().getInt("cooldown-seconds", 300);
            if (cooldownSeconds > 0) {
                UUID playerUUID = player.getUniqueId();
                String cooldownPath = "cooldowns." + playerUUID.toString();
                long lastSuggestion = SuggestionZ.this.suggestionsConfig.getLong(cooldownPath, 0L);
                long currentTime = System.currentTimeMillis();
                if (lastSuggestion > 0L && (currentTime - lastSuggestion) / 1000L < (long)cooldownSeconds) {
                    long l = (long)cooldownSeconds - (currentTime - lastSuggestion) / 1000L;
                    player.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.on-cooldown").replace("%time%", String.valueOf(l))));
                    return true;
                }
                SuggestionZ.this.suggestionsConfig.set(cooldownPath, currentTime);
            }
            String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            String suggestionsPath = "suggestions." + topic;
            if (!SuggestionZ.this.suggestionsConfig.isConfigurationSection(suggestionsPath)) {
                SuggestionZ.this.suggestionsConfig.createSection(suggestionsPath);
            }
            ConfigurationSection topicSection = SuggestionZ.this.suggestionsConfig.getConfigurationSection(suggestionsPath);
            int id = 1;
            if (topicSection != null && !topicSection.getKeys(false).isEmpty()) {
                for (String key : topicSection.getKeys(false)) {
                    try {
                        int n = Integer.parseInt(key);
                        if (n < id) continue;
                        id = n + 1;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            SuggestionZ.this.suggestionsConfig.set(suggestionsPath + "." + id + ".player", player.getName());
            SuggestionZ.this.suggestionsConfig.set(suggestionsPath + "." + id + ".uuid", player.getUniqueId().toString());
            SuggestionZ.this.suggestionsConfig.set(suggestionsPath + "." + id + ".suggestion", suggestion);
            SuggestionZ.this.suggestionsConfig.set(suggestionsPath + "." + id + ".date", date);
            SuggestionZ.this.saveSuggestionsConfig();
            player.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.suggestion-added").replace("%topic%", topic)));
            if (SuggestionZ.this.getConfig().getBoolean("notify-admins-on-suggestion", true)) {
                String notifyMessage = SuggestionZ.this.getConfig().getString("messages.admin-notification").replace("%player%", player.getName()).replace("%topic%", topic).replace("%suggestion%", suggestion);
                for (Player player2 : SuggestionZ.this.getServer().getOnlinePlayers()) {
                    if (!player2.hasPermission("suggestionz.admin.notify")) continue;
                    player2.sendMessage(SuggestionZ.this.colorize(notifyMessage));
                }
            }
            return true;
        }

        private boolean isValidTopic(String topic) {
            List<String> topics = SuggestionZ.this.getConfig().getStringList("default-topics");
            return topics.contains(topic.toLowerCase());
        }
    }

    private class IdeaListCommand
    implements CommandExecutor {
        private IdeaListCommand() {
        }

        @Override
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            ConfigurationSection suggestionsSection;
            if (!sender.hasPermission("suggestionz.admin.list")) {
                sender.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.no-permission")));
                return true;
            }
            String topic = null;
            int page = 1;
            if (args.length >= 1) {
                if (this.isValidTopic(args[0])) {
                    topic = args[0].toLowerCase();
                    if (args.length >= 2) {
                        try {
                            page = Integer.parseInt(args[1]);
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.invalid-page")));
                            return true;
                        }
                    }
                } else {
                    try {
                        page = Integer.parseInt(args[0]);
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.invalid-topic")));
                        return true;
                    }
                }
            }
            if ((suggestionsSection = SuggestionZ.this.suggestionsConfig.getConfigurationSection("suggestions")) == null || suggestionsSection.getKeys(false).isEmpty()) {
                sender.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.no-suggestions")));
                return true;
            }
            int suggestionsPerPage = SuggestionZ.this.getConfig().getInt("suggestions-per-page", 5);
            ArrayList<String> allSuggestions = new ArrayList<String>();
            if (topic != null) {
                ConfigurationSection topicSection = suggestionsSection.getConfigurationSection(topic);
                if (topicSection == null || topicSection.getKeys(false).isEmpty()) {
                    sender.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.no-suggestions-topic").replace("%topic%", topic)));
                    return true;
                }
                for (String key : topicSection.getKeys(false)) {
                    String playerName = topicSection.getString(key + ".player");
                    String suggestion = topicSection.getString(key + ".suggestion");
                    String date = topicSection.getString(key + ".date");
                    String formattedSuggestion = SuggestionZ.this.getConfig().getString("messages.suggestion-format").replace("%id%", key).replace("%topic%", topic).replace("%player%", playerName).replace("%suggestion%", suggestion).replace("%date%", date);
                    allSuggestions.add(formattedSuggestion);
                }
            } else {
                for (String topicKey : suggestionsSection.getKeys(false)) {
                    ConfigurationSection topicSection = suggestionsSection.getConfigurationSection(topicKey);
                    if (topicSection == null) continue;
                    for (String key : topicSection.getKeys(false)) {
                        String playerName = topicSection.getString(key + ".player");
                        String suggestion = topicSection.getString(key + ".suggestion");
                        String date = topicSection.getString(key + ".date");
                        String formattedSuggestion = SuggestionZ.this.getConfig().getString("messages.suggestion-format").replace("%id%", key).replace("%topic%", topicKey).replace("%player%", playerName).replace("%suggestion%", suggestion).replace("%date%", date);
                        allSuggestions.add(formattedSuggestion);
                    }
                }
            }
            int totalPages = Math.max(1, (int)Math.ceil((double)allSuggestions.size() / (double)suggestionsPerPage));
            if (page < 1) {
                page = 1;
            }
            if (page > totalPages) {
                page = totalPages;
            }
            sender.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.suggestion-list-header").replace("%page%", String.valueOf(page)).replace("%total%", String.valueOf(totalPages)).replace("%topic%", topic != null ? topic : "all")));
            int startIndex = (page - 1) * suggestionsPerPage;
            int endIndex = Math.min(startIndex + suggestionsPerPage, allSuggestions.size());
            if (allSuggestions.isEmpty()) {
                sender.sendMessage(SuggestionZ.this.colorize("&cNo suggestions found."));
            } else {
                for (int i = startIndex; i < endIndex; ++i) {
                    sender.sendMessage(SuggestionZ.this.colorize((String)allSuggestions.get(i)));
                }
            }
            sender.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.suggestion-list-footer")));
            return true;
        }

        private boolean isValidTopic(String topic) {
            List<String> topics = SuggestionZ.this.getConfig().getStringList("default-topics");
            return topics.contains(topic.toLowerCase());
        }
    }

    private class ManageTopicsCommand
    implements CommandExecutor {
        private ManageTopicsCommand() {
        }

        @Override
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (!sender.hasPermission("suggestionz.admin.topics")) {
                sender.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.no-permission")));
                return true;
            }
            if (args.length < 1) {
                sender.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.topics-usage")));
                return true;
            }
            String action = args[0].toLowerCase();
            List<String> topics = SuggestionZ.this.getConfig().getStringList("default-topics");
            switch (action) {
                case "list": {
                    sender.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.topics-list-header")));
                    for (String topic : topics) {
                        sender.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.topics-list-item").replace("%topic%", topic)));
                    }
                    break;
                }
                case "add": {
                    if (args.length < 2) {
                        sender.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.topics-add-usage")));
                        return true;
                    }
                    String newTopic = args[1].toLowerCase();
                    if (topics.contains(newTopic)) {
                        sender.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.topic-exists").replace("%topic%", newTopic)));
                        return true;
                    }
                    topics.add(newTopic);
                    SuggestionZ.this.getConfig().set("default-topics", topics);
                    SuggestionZ.this.saveConfig();
                    sender.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.topic-added").replace("%topic%", newTopic)));
                    break;
                }
                case "remove": {
                    if (args.length < 2) {
                        sender.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.topics-remove-usage")));
                        return true;
                    }
                    String removeTopic = args[1].toLowerCase();
                    if (!topics.contains(removeTopic)) {
                        sender.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.topic-not-exists").replace("%topic%", removeTopic)));
                        return true;
                    }
                    topics.remove(removeTopic);
                    SuggestionZ.this.getConfig().set("default-topics", topics);
                    SuggestionZ.this.saveConfig();
                    sender.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.topic-removed").replace("%topic%", removeTopic)));
                    break;
                }
                default: {
                    sender.sendMessage(SuggestionZ.this.colorize(SuggestionZ.this.getConfig().getString("messages.topics-usage")));
                }
            }
            return true;
        }
    }
}

