/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.devilSMP;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.poggercity.devilSMP.DevilSMP;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class AzgrelAbility
implements Listener {
    private final Map<UUID, Long> cooldown = new HashMap<UUID, Long>();
    private final DevilSMP plugin;

    public AzgrelAbility(DevilSMP plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onUse(PlayerInteractEvent e) {
        long remaining;
        if (!e.getAction().name().contains("RIGHT") || e.getHand() != EquipmentSlot.HAND || !e.getPlayer().isSneaking()) {
            return;
        }
        final Player player = e.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName()) {
            return;
        }
        String name = ChatColor.stripColor((String)item.getItemMeta().getDisplayName());
        if (!name.contains("Azgrel")) {
            return;
        }
        long now = System.currentTimeMillis();
        if (this.cooldown.containsKey(player.getUniqueId()) && (remaining = this.cooldown.get(player.getUniqueId()) - now) > 0L) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Ability is on cooldown for " + remaining / 1000L + " seconds!");
            return;
        }
        this.cooldown.put(player.getUniqueId(), now + 60000L);
        player.setVelocity(new Vector(0.0, 1.2, 0.0));
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_BLAZE_SHOOT, 1.0f, 1.0f);
        new BukkitRunnable(this){
            int ticks = 0;

            public void run() {
                if (player.isOnGround()) {
                    this.cancel();
                } else {
                    player.getWorld().spawnParticle(Particle.TOTEM_OF_UNDYING, player.getLocation(), 10, 0.2, 0.2, 0.2, 0.0);
                }
                if (++this.ticks > 20) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
        new BukkitRunnable(this){
            boolean landed = false;

            public void run() {
                if (player.isOnGround() && !this.landed) {
                    this.landed = true;
                    Location loc = player.getLocation();
                    loc.getWorld().playSound(loc, Sound.ENTITY_GENERIC_EXPLODE, 1.2f, 1.0f);
                    loc.getWorld().playSound(loc, Sound.ITEM_TOTEM_USE, 1.0f, 1.0f);
                    loc.getWorld().spawnParticle(Particle.EXPLOSION, loc, 1);
                    loc.getWorld().spawnParticle(Particle.FLAME, loc, 100, 0.5, 0.5, 0.5, 0.1);
                    loc.getWorld().spawnParticle(Particle.WITCH, loc, 80, 1.0, 1.0, 1.0, 0.05);
                    loc.getWorld().spawnParticle(Particle.SMOKE, loc, 80, 1.0, 0.5, 1.0, 0.02);
                    for (Entity nearby : loc.getWorld().getNearbyEntities(loc, 5.0, 5.0, 5.0)) {
                        LivingEntity target;
                        if (!(nearby instanceof LivingEntity) || (target = (LivingEntity)nearby).equals((Object)player)) continue;
                        target.setNoDamageTicks(0);
                        double newHealth = Math.max(0.0, target.getHealth() - 10.0);
                        target.setHealth(newHealth);
                        target.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 100, 0));
                    }
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent e) {
        ItemStack item = e.getItemDrop().getItemStack();
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName() && ChatColor.stripColor((String)item.getItemMeta().getDisplayName()).contains("Azgrel")) {
            e.setCancelled(true);
            e.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "You cannot drop this sigil!");
        }
    }
}

