/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.devilSMP;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import me.poggercity.devilSMP.DevilSMP;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class DevilGUICommand
implements Listener,
CommandExecutor {
    private final DevilSMP plugin;
    private final String GUI_TITLE = String.valueOf(ChatColor.DARK_RED) + "Devil's Sigils";

    public DevilGUICommand(DevilSMP plugin) {
        this.plugin = plugin;
        plugin.getCommand("devilgui").setExecutor((CommandExecutor)this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openGUI(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)this.GUI_TITLE);
        gui.setItem(10, this.createSigil("Malzereth", ChatColor.DARK_PURPLE));
        gui.setItem(11, this.createSigil("Azgrel", ChatColor.RED));
        gui.setItem(12, this.createSigil("Serkavos", ChatColor.GOLD));
        gui.setItem(13, this.createSigil("Thamuzel", ChatColor.DARK_RED));
        gui.setItem(14, this.createSigil("Nyxarion", ChatColor.DARK_AQUA));
        gui.setItem(15, this.createSigil("Drexithar", ChatColor.DARK_GRAY));
        gui.setItem(16, this.createSigil("Gorvul", ChatColor.GREEN));
        player.openInventory(gui);
        player.playSound(player.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 1.0f);
    }

    private ItemStack createSigil(String name, ChatColor color) {
        ItemStack item = new ItemStack(Material.ENCHANTED_BOOK);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(String.valueOf(color) + name + "'s Sigil");
        ArrayList<CallSite> lore = new ArrayList<CallSite>();
        lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Shift + Right-click to awaken this sigil's power.")));
        meta.setLore(lore);
        meta.addEnchant(Enchantment.BINDING_CURSE, 1, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(meta);
        return item;
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        if (!e.getView().getTitle().equals(this.GUI_TITLE)) {
            return;
        }
        e.setCancelled(true);
        if (e.getCurrentItem() == null || e.getCurrentItem().getType() != Material.ENCHANTED_BOOK) {
            return;
        }
        Player player = (Player)e.getWhoClicked();
        ItemStack newSigil = e.getCurrentItem().clone();
        String newDisplay = ChatColor.stripColor((String)newSigil.getItemMeta().getDisplayName());
        for (int i = 0; i < player.getInventory().getSize(); ++i) {
            ItemStack item = player.getInventory().getItem(i);
            if (item == null || !item.hasItemMeta() || item.getType() != Material.ENCHANTED_BOOK || !ChatColor.stripColor((String)item.getItemMeta().getDisplayName()).endsWith("Sigil")) continue;
            player.getInventory().setItem(i, null);
        }
        player.getInventory().addItem(new ItemStack[]{newSigil});
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.2f);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have received " + String.valueOf(ChatColor.YELLOW) + newDisplay);
    }

    @EventHandler
    public void onDrag(InventoryDragEvent e) {
        if (e.getView().getTitle().equals(this.GUI_TITLE)) {
            e.setCancelled(true);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        this.openGUI(player);
        return true;
    }

    public static void giveSigil(DevilSMP plugin, Player player, String name) {
        ChatColor color = ChatColor.RED;
        switch (name.toLowerCase()) {
            case "malzereth": {
                color = ChatColor.DARK_PURPLE;
                break;
            }
            case "azgrel": {
                color = ChatColor.RED;
                break;
            }
            case "serkavos": {
                color = ChatColor.GOLD;
                break;
            }
            case "thamuzel": {
                color = ChatColor.DARK_RED;
                break;
            }
            case "nyxarion": {
                color = ChatColor.DARK_AQUA;
                break;
            }
            case "drexithar": {
                color = ChatColor.DARK_GRAY;
                break;
            }
            case "gorvul": {
                color = ChatColor.GREEN;
            }
        }
        ItemStack sigil = new ItemStack(Material.ENCHANTED_BOOK);
        ItemMeta meta = sigil.getItemMeta();
        meta.setDisplayName(String.valueOf(color) + name + "'s Sigil");
        meta.addEnchant(Enchantment.BINDING_CURSE, 1, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        ArrayList<CallSite> lore = new ArrayList<CallSite>();
        lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Shift + Right-click to awaken this sigil's power.")));
        meta.setLore(lore);
        sigil.setItemMeta(meta);
        for (int i = 0; i < player.getInventory().getSize(); ++i) {
            ItemStack item = player.getInventory().getItem(i);
            if (item == null || !item.hasItemMeta() || item.getType() != Material.ENCHANTED_BOOK || !ChatColor.stripColor((String)item.getItemMeta().getDisplayName()).endsWith("Sigil")) continue;
            player.getInventory().setItem(i, null);
        }
        player.getInventory().addItem(new ItemStack[]{sigil});
    }
}

