/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.devilSMP;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import me.poggercity.devilSMP.DevilSMP;
import org.bukkit.ChatColor;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class DrexitharAbility
implements Listener {
    private final Map<UUID, Long> cooldown = new HashMap<UUID, Long>();
    private final DevilSMP plugin;

    public DrexitharAbility(DevilSMP plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onUse(PlayerInteractEvent e) {
        long remaining;
        if (!e.getAction().name().contains("RIGHT") || e.getHand() != EquipmentSlot.HAND || !e.getPlayer().isSneaking()) {
            return;
        }
        final Player player = e.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName()) {
            return;
        }
        String name = ChatColor.stripColor((String)item.getItemMeta().getDisplayName());
        if (!name.contains("Drexithar")) {
            return;
        }
        long now = System.currentTimeMillis();
        if (this.cooldown.containsKey(player.getUniqueId()) && (remaining = this.cooldown.get(player.getUniqueId()) - now) > 0L) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Ability on cooldown for " + remaining / 1000L + "s!");
            return;
        }
        this.cooldown.put(player.getUniqueId(), now + 60000L);
        player.playSound(player.getLocation(), Sound.ENTITY_ELDER_GUARDIAN_CURSE, 1.0f, 0.7f);
        final HashSet pulledEntities = new HashSet();
        new BukkitRunnable(this){
            int ticks = 0;

            public void run() {
                if (this.ticks >= 100) {
                    for (LivingEntity target : pulledEntities) {
                        if (target.isDead() || !(target.getLocation().distance(player.getLocation()) < 10.0)) continue;
                        Vector random = new Vector(Math.random() - 0.5, 0.0, Math.random() - 0.5).normalize().multiply(1.2).setY(0.8);
                        target.setVelocity(random.multiply(1.5));
                        target.getWorld().spawnParticle(Particle.EXPLOSION, target.getLocation(), 20, 0.5, 0.5, 0.5, 0.1);
                        target.getWorld().playSound(target.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
                    }
                    this.cancel();
                    return;
                }
                for (Entity entity : player.getNearbyEntities(8.0, 8.0, 8.0)) {
                    if (!(entity instanceof LivingEntity) || entity == player) continue;
                    LivingEntity target = (LivingEntity)entity;
                    pulledEntities.add(target);
                    Vector direction = player.getLocation().toVector().subtract(target.getLocation().toVector()).normalize().multiply(0.25);
                    target.setVelocity(target.getVelocity().add(direction));
                    target.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 20, 1, true, false, false));
                    target.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, 20, 0, true, false, false));
                    target.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 20, 0, true, false, false));
                    target.getWorld().spawnParticle(Particle.LARGE_SMOKE, target.getLocation().add(0.0, 1.0, 0.0), 2, 0.2, 0.2, 0.2, 0.01);
                    target.getWorld().spawnParticle(Particle.DRAGON_BREATH, target.getLocation(), 3, 0.2, 0.2, 0.2, 0.05);
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent e) {
        ItemStack item = e.getItemDrop().getItemStack();
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName() && ChatColor.stripColor((String)item.getItemMeta().getDisplayName()).contains("Drexithar")) {
            e.setCancelled(true);
            e.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "You cannot drop this sigil!");
        }
    }
}

