/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.devilSMP;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GorvulAbility
implements Listener {
    private final JavaPlugin plugin;
    private final Set<UUID> cooldown = new HashSet<UUID>();
    private final Set<UUID> empoweredCrits = new HashSet<UUID>();

    public GorvulAbility(JavaPlugin plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onUse(PlayerInteractEvent event) {
        final Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        String name = ChatColor.stripColor((String)item.getItemMeta().getDisplayName());
        if (!name.equalsIgnoreCase("Gorvul's Sigil")) {
            return;
        }
        if (!player.isSneaking() || !event.getAction().toString().contains("RIGHT")) {
            return;
        }
        if (this.cooldown.contains(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Gorvul's Sigil is on cooldown.");
            return;
        }
        this.cooldown.add(player.getUniqueId());
        this.empoweredCrits.add(player.getUniqueId());
        player.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, 100, 2, false, false));
        final Location center = player.getLocation();
        final HashSet affected = new HashSet();
        new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                this.ticks += 10;
                if (this.ticks >= 100) {
                    GorvulAbility.this.empoweredCrits.remove(player.getUniqueId());
                    this.cancel();
                    center.getWorld().spawnParticle(Particle.BLOCK, center, 80, 2.0, 0.5, 2.0, (Object)Material.DEEPSLATE.createBlockData());
                    center.getWorld().playSound(center, Sound.ENTITY_WITHER_BREAK_BLOCK, 2.0f, 0.7f);
                    for (Player p : affected) {
                        if (p.equals((Object)player)) continue;
                        Vector dir = p.getLocation().toVector().subtract(center.toVector()).normalize().multiply(1.8).setY(0.6);
                        p.setVelocity(dir);
                        p.damage(6.0);
                    }
                    return;
                }
                center.getWorld().spawnParticle(Particle.WITCH, center, 60, 3.0, 0.5, 3.0, 0.1);
                center.getWorld().spawnParticle(Particle.SMOKE, center, 10, 2.0, 0.1, 2.0, 0.01);
                for (Entity entity : center.getWorld().getNearbyEntities(center, 10.0, 10.0, 10.0)) {
                    Player target;
                    if (!(entity instanceof Player) || (target = (Player)entity).equals((Object)player)) continue;
                    affected.add(target);
                    Location freezeLoc = target.getLocation().clone();
                    target.teleport(freezeLoc);
                    target.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 20, 0, false, false));
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 10L);
        new BukkitRunnable(){

            public void run() {
                GorvulAbility.this.cooldown.remove(player.getUniqueId());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Gorvul's Sigil is ready.");
            }
        }.runTaskLater((Plugin)this.plugin, 1500L);
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent e) {
        String name;
        ItemStack item = e.getItemDrop().getItemStack();
        if (item != null && item.hasItemMeta() && (name = ChatColor.stripColor((String)item.getItemMeta().getDisplayName())).endsWith("Sigil")) {
            e.setCancelled(true);
            e.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "You cannot drop sigils.");
        }
    }

    @EventHandler
    public void onHit(EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player damager = (Player)entity;
        if (!this.empoweredCrits.contains(damager.getUniqueId())) {
            return;
        }
        e.getEntity().getWorld().spawnParticle(Particle.CRIT, e.getEntity().getLocation().add(0.0, 1.0, 0.0), 15);
        e.getEntity().getWorld().playSound(e.getEntity().getLocation(), Sound.ENTITY_PLAYER_ATTACK_CRIT, 1.0f, 1.0f);
        e.setDamage(e.getDamage() + 2.0);
    }
}

