/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.devilSMP;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.poggercity.devilSMP.DevilSMP;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class MalzerethAbility
implements Listener {
    private final Map<UUID, Long> cooldown = new HashMap<UUID, Long>();
    private final DevilSMP plugin;

    public MalzerethAbility(DevilSMP plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onUse(PlayerInteractEvent e) {
        long remaining;
        if (!e.getAction().name().contains("RIGHT") || e.getHand() != EquipmentSlot.HAND || !e.getPlayer().isSneaking()) {
            return;
        }
        final Player player = e.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName()) {
            return;
        }
        String name = ChatColor.stripColor((String)item.getItemMeta().getDisplayName());
        if (!name.contains("Malzereth")) {
            return;
        }
        long now = System.currentTimeMillis();
        if (this.cooldown.containsKey(player.getUniqueId()) && (remaining = this.cooldown.get(player.getUniqueId()) - now) > 0L) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Ability is on cooldown for " + remaining / 1000L + " seconds!");
            return;
        }
        this.cooldown.put(player.getUniqueId(), now + 60000L);
        player.playSound(player.getLocation(), Sound.ENTITY_ILLUSIONER_CAST_SPELL, 1.0f, 1.0f);
        new BukkitRunnable(this){
            int ticks = 0;
            final Map<UUID, Integer> targetHitTracker = new HashMap<UUID, Integer>();

            public void run() {
                if (this.ticks >= 100) {
                    this.cancel();
                    return;
                }
                Location start = player.getEyeLocation();
                Vector direction = start.getDirection().normalize();
                for (int i = 0; i < 35; ++i) {
                    Location loc = start.clone().add(direction.clone().multiply(i));
                    player.getWorld().spawnParticle(Particle.ENCHANTED_HIT, loc, 1, 0.0, 0.0, 0.0, 0.0);
                    player.getWorld().spawnParticle(Particle.WITCH, loc, 1, 0.0, 0.0, 0.0, 0.01);
                    player.getWorld().spawnParticle(Particle.DAMAGE_INDICATOR, loc, 1, 0.05, 0.05, 0.05, 0.01);
                }
                for (Entity entity : player.getNearbyEntities(35.0, 35.0, 35.0)) {
                    int lastHit;
                    if (!(entity instanceof LivingEntity) || entity == player) continue;
                    LivingEntity target = (LivingEntity)entity;
                    Location eyeLoc = player.getEyeLocation();
                    Location targetLoc = target.getLocation().add(0.0, 1.0, 0.0);
                    Vector toTarget = targetLoc.toVector().subtract(eyeLoc.toVector()).normalize();
                    double angle = direction.angle(toTarget);
                    if (!(angle < 0.1) || this.ticks - (lastHit = this.targetHitTracker.getOrDefault(target.getUniqueId(), -10).intValue()) < 10) continue;
                    this.targetHitTracker.put(target.getUniqueId(), this.ticks);
                    target.setNoDamageTicks(0);
                    target.getWorld().playSound(target.getLocation(), Sound.ENTITY_GUARDIAN_AMBIENT_LAND, 0.6f, 1.2f);
                    double finalHealth = target.getHealth() - 2.0;
                    target.setHealth(Math.max(0.0, finalHealth));
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent e) {
        ItemStack item = e.getItemDrop().getItemStack();
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName() && ChatColor.stripColor((String)item.getItemMeta().getDisplayName()).contains("Malzereth")) {
            e.setCancelled(true);
            e.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "You cannot drop this sigil!");
        }
    }
}

