/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.devilSMP;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.poggercity.devilSMP.DevilSMP;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class NyxarionAbility
implements Listener {
    private final Map<UUID, Long> cooldown = new HashMap<UUID, Long>();
    private final DevilSMP plugin;

    public NyxarionAbility(DevilSMP plugin) {
        this.plugin = plugin;
        this.startSmokeAura();
    }

    @EventHandler
    public void onUse(PlayerInteractEvent e) {
        long remaining;
        if (!e.getAction().name().contains("RIGHT") || e.getHand() != EquipmentSlot.HAND || !e.getPlayer().isSneaking()) {
            return;
        }
        final Player player = e.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName()) {
            return;
        }
        String name = ChatColor.stripColor((String)item.getItemMeta().getDisplayName());
        if (!name.contains("Nyxarion")) {
            return;
        }
        long now = System.currentTimeMillis();
        if (this.cooldown.containsKey(player.getUniqueId()) && (remaining = this.cooldown.get(player.getUniqueId()) - now) > 0L) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Ability is on cooldown for " + remaining / 1000L + "s!");
            return;
        }
        this.cooldown.put(player.getUniqueId(), now + 60000L);
        player.playSound(player.getLocation(), Sound.ENTITY_WITHER_HURT, 1.0f, 1.0f);
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.hidePlayer((Plugin)this.plugin, player);
        }
        new BukkitRunnable(){
            int time = 0;

            public void run() {
                if (this.time >= 10) {
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        p.showPlayer((Plugin)NyxarionAbility.this.plugin, player);
                    }
                    this.cancel();
                    return;
                }
                for (int r = 1; r <= 5; ++r) {
                    for (double angle = 0.0; angle < 360.0; angle += 5.0) {
                        double x = Math.cos(Math.toRadians(angle)) * (double)r;
                        double z = Math.sin(Math.toRadians(angle)) * (double)r;
                        for (int i = 0; i < 5; ++i) {
                            Location loc = player.getLocation().add(x, 0.1 + (double)i * 0.1, z);
                            player.getWorld().spawnParticle(Particle.LARGE_SMOKE, loc, 1, 0.0, 0.0, 0.0, 0.0);
                            player.getWorld().spawnParticle(Particle.WITCH, loc, 1, 0.1, 0.1, 0.1, 0.01);
                            player.getWorld().spawnParticle(Particle.DRAGON_BREATH, loc, 1, 0.1, 0.1, 0.1, 0.02);
                        }
                    }
                }
                for (Player nearby : player.getWorld().getPlayers()) {
                    if (nearby == player || !(nearby.getLocation().distance(player.getLocation()) <= 10.0)) continue;
                    nearby.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, (10 - this.time) * 20, 1));
                    nearby.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, (10 - this.time) * 20, 1));
                }
                ++this.time;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent e) {
        ItemStack item = e.getItemDrop().getItemStack();
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName() && ChatColor.stripColor((String)item.getItemMeta().getDisplayName()).contains("Nyxarion")) {
            e.setCancelled(true);
            e.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "You cannot drop this sigil!");
        }
    }

    private void startSmokeAura() {
        new BukkitRunnable(this){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    ItemStack item = player.getInventory().getItemInMainHand();
                    if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName() || !ChatColor.stripColor((String)item.getItemMeta().getDisplayName()).contains("Nyxarion")) continue;
                    player.getWorld().spawnParticle(Particle.LARGE_SMOKE, player.getLocation().add(0.0, 1.0, 0.0), 10, 0.3, 0.3, 0.3, 0.01);
                    player.getWorld().spawnParticle(Particle.PORTAL, player.getLocation().add(0.0, 1.0, 0.0), 5, 0.3, 0.3, 0.3, 0.02);
                    player.getWorld().spawnParticle(Particle.END_ROD, player.getLocation().add(0.0, 1.0, 0.0), 5, 0.3, 0.3, 0.3, (Object)new Particle.DustOptions(Color.PURPLE, 1.0f));
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 10L);
    }
}

