/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.devilSMP;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import me.poggercity.devilSMP.DevilSMP;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class SerkavosAbility
implements Listener {
    private final Map<UUID, Long> cooldown = new HashMap<UUID, Long>();
    private final Set<UUID> empoweredHit = new HashSet<UUID>();
    private final DevilSMP plugin;

    public SerkavosAbility(DevilSMP plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onUse(PlayerInteractEvent e) {
        long remaining;
        if (!e.getAction().name().contains("RIGHT") || e.getHand() != EquipmentSlot.HAND || !e.getPlayer().isSneaking()) {
            return;
        }
        Player player = e.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName()) {
            return;
        }
        String name = ChatColor.stripColor((String)item.getItemMeta().getDisplayName());
        if (!name.contains("Serkavos")) {
            return;
        }
        long now = System.currentTimeMillis();
        if (this.cooldown.containsKey(player.getUniqueId()) && (remaining = this.cooldown.get(player.getUniqueId()) - now) > 0L) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Ability is on cooldown for " + remaining / 1000L + "s!");
            return;
        }
        this.cooldown.put(player.getUniqueId(), now + 60000L);
        this.empoweredHit.add(player.getUniqueId());
        player.playSound(player.getLocation(), Sound.ITEM_FIRECHARGE_USE, 1.0f, 1.2f);
        player.playSound(player.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 0.8f, 1.4f);
        Location center = player.getLocation();
        for (double angle = 0.0; angle < 360.0; angle += 10.0) {
            double x = Math.cos(Math.toRadians(angle)) * 7.0;
            double z = Math.sin(Math.toRadians(angle)) * 7.0;
            Location loc = center.clone().add(x, 0.1, z);
            center.getWorld().spawnParticle(Particle.FIREWORK, loc, 8, 0.2, 0.5, 0.2, 0.0);
            center.getWorld().spawnParticle(Particle.WITCH, loc, 4, 0.1, 0.3, 0.1, 0.0);
            center.getWorld().spawnParticle(Particle.FLAME, loc, 4, 0.1, 0.2, 0.1, 0.01);
        }
        for (Entity entity : player.getNearbyEntities(7.0, 7.0, 7.0)) {
            if (!(entity instanceof Player) || entity == player) continue;
            entity.setVelocity(new Vector(0, 1, 0));
            ((Player)entity).addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, 200, 0));
        }
    }

    @EventHandler
    public void onHit(EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player damager = (Player)entity;
        if (this.empoweredHit.remove(damager.getUniqueId())) {
            e.setCancelled(true);
            Entity entity2 = e.getEntity();
            if (entity2 instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity2;
                double finalDamage = 8.0;
                double absorption = target.getAbsorptionAmount();
                if (absorption >= finalDamage) {
                    target.setAbsorptionAmount(absorption - finalDamage);
                } else {
                    double remaining = finalDamage - absorption;
                    target.setAbsorptionAmount(0.0);
                    target.setHealth(Math.max(0.0, target.getHealth() - remaining));
                }
                target.getWorld().playSound(target.getLocation(), Sound.ITEM_MACE_SMASH_GROUND_HEAVY, 1.0f, 1.0f);
                target.getWorld().playSound(target.getLocation(), Sound.ENTITY_BLAZE_HURT, 0.6f, 1.8f);
                target.getWorld().spawnParticle(Particle.ENCHANTED_HIT, target.getLocation(), 20, 0.5, 1.0, 0.5, 0.1);
                target.getWorld().spawnParticle(Particle.EXPLOSION, target.getLocation(), 5, 0.3, 0.5, 0.3, 0.05);
            }
        }
    }

    @EventHandler
    public void onWindChargeUse(PlayerToggleFlightEvent e) {
        Player player = e.getPlayer();
        if (!player.getInventory().contains(Material.WIND_CHARGE)) {
            return;
        }
        boolean hasSerkavos = Arrays.stream(player.getInventory().getContents()).filter(Objects::nonNull).anyMatch(item -> item.hasItemMeta() && item.getItemMeta().hasDisplayName() && ChatColor.stripColor((String)item.getItemMeta().getDisplayName()).contains("Serkavos"));
        if (hasSerkavos) {
            int currentCooldown = player.getCooldown(Material.WIND_CHARGE);
            int newCooldown = Math.max(1, currentCooldown / 3);
            player.setCooldown(Material.WIND_CHARGE, newCooldown);
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent e) {
        ItemStack item = e.getItemDrop().getItemStack();
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName() && ChatColor.stripColor((String)item.getItemMeta().getDisplayName()).contains("Serkavos")) {
            e.setCancelled(true);
            e.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "You cannot drop this sigil!");
        }
    }
}

