/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.devilSMP;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.poggercity.devilSMP.DevilSMP;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class SigilDeathHandler
implements Listener {
    private final DevilSMP plugin;
    private final Map<UUID, ItemStack> sigilReturnMap = new HashMap<UUID, ItemStack>();

    public SigilDeathHandler(DevilSMP plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        UUID uuid = player.getUniqueId();
        ItemStack savedSigil = null;
        for (ItemStack item2 : player.getInventory()) {
            String displayName;
            if (item2 == null || !item2.getType().toString().contains("BOOK") || !item2.hasItemMeta() || (displayName = item2.getItemMeta().getDisplayName()) == null || !displayName.endsWith("Sigil")) continue;
            savedSigil = item2.clone();
            break;
        }
        if (savedSigil != null) {
            this.sigilReturnMap.put(uuid, savedSigil);
            ItemStack finalSavedSigil = savedSigil;
            event.getDrops().removeIf(item -> item.isSimilar(finalSavedSigil));
        }
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (this.sigilReturnMap.containsKey(uuid)) {
            Player finalPlayer = player;
            UUID finalUuid = uuid;
            ItemStack returnedSigil = this.sigilReturnMap.get(finalUuid);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                for (int i = 0; i < finalPlayer.getInventory().getSize(); ++i) {
                    ItemStack item = finalPlayer.getInventory().getItem(i);
                    if (item == null || !item.isSimilar(returnedSigil)) continue;
                    finalPlayer.getInventory().setItem(i, null);
                }
                finalPlayer.getInventory().addItem(new ItemStack[]{returnedSigil.clone()});
                this.sigilReturnMap.remove(finalUuid);
            }, 20L);
        }
    }
}

