/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.devilSMP;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.poggercity.devilSMP.DevilSMP;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class SigilPreventor
implements Listener {
    private final DevilSMP plugin;
    private final Set<UUID> restorePending = new HashSet<UUID>();
    private final Map<UUID, ItemStack> savedSigils = new HashMap<UUID, ItemStack>();
    private final Set<UUID> recentlyMessaged = new HashSet<UUID>();

    public SigilPreventor(DevilSMP plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private boolean isSigil(ItemStack item) {
        if (item == null || item.getType() != Material.ENCHANTED_BOOK) {
            return false;
        }
        if (!item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        return meta.hasDisplayName() && ChatColor.stripColor((String)meta.getDisplayName()).endsWith("Sigil");
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        InventoryType topType = e.getView().getTopInventory().getType();
        if ((topType == InventoryType.CHEST || topType == InventoryType.BARREL || topType == InventoryType.SHULKER_BOX || topType == InventoryType.ENDER_CHEST) && (this.isSigil(e.getCurrentItem()) || this.isSigil(e.getCursor()))) {
            e.setCancelled(true);
            e.getWhoClicked().sendMessage(String.valueOf(ChatColor.RED) + "You can't store sigils in containers.");
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent e) {
        Player player = e.getPlayer();
        UUID uuid = player.getUniqueId();
        if (this.isSigil(e.getItemDrop().getItemStack())) {
            e.setCancelled(true);
            if (this.recentlyMessaged.add(uuid)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot drop your sigil.");
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.recentlyMessaged.remove(uuid), 10L);
            }
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent e) {
        Player player = e.getEntity();
        Iterator iterator = e.getDrops().iterator();
        while (iterator.hasNext()) {
            ItemStack item = (ItemStack)iterator.next();
            if (!this.isSigil(item)) continue;
            this.savedSigils.put(player.getUniqueId(), item.clone());
            this.restorePending.add(player.getUniqueId());
            iterator.remove();
        }
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent e) {
        Player player = e.getPlayer();
        UUID uuid = player.getUniqueId();
        if (this.restorePending.contains(uuid)) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                ItemStack sigil = this.savedSigils.remove(uuid);
                if (sigil != null) {
                    player.getInventory().addItem(new ItemStack[]{sigil});
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your sigil has been restored.");
                }
                this.restorePending.remove(uuid);
            }, 20L);
        }
    }
}

