/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.devilSMP;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.poggercity.devilSMP.DevilSMP;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ThamuzelAbility
implements Listener {
    private final DevilSMP plugin;
    private final Map<UUID, Long> cooldown = new HashMap<UUID, Long>();

    public ThamuzelAbility(DevilSMP plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onActivate(PlayerInteractEvent e) {
        long remaining;
        if (!e.getAction().name().contains("RIGHT") || e.getHand() != EquipmentSlot.HAND || !e.getPlayer().isSneaking()) {
            return;
        }
        final Player player = e.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName()) {
            return;
        }
        String name = ChatColor.stripColor((String)item.getItemMeta().getDisplayName());
        if (!name.contains("Thamuzel")) {
            return;
        }
        long now = System.currentTimeMillis();
        if (this.cooldown.containsKey(player.getUniqueId()) && (remaining = this.cooldown.get(player.getUniqueId()) - now) > 0L) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Cooldown: " + remaining / 1000L + "s left.");
            return;
        }
        this.cooldown.put(player.getUniqueId(), now + 75000L);
        player.sendMessage(String.valueOf(ChatColor.DARK_RED) + "You have summoned Thamuzel's vortex!");
        player.playSound(player.getLocation(), Sound.ITEM_FIRECHARGE_USE, 1.0f, 1.0f);
        new BukkitRunnable(this){
            int ticks = 0;
            final Set<UUID> affected = new HashSet<UUID>();

            public void run() {
                if (this.ticks >= 140) {
                    for (Entity entity : player.getNearbyEntities(10.0, 10.0, 10.0)) {
                        if (!(entity instanceof LivingEntity) || entity == player) continue;
                        entity.setVelocity(new Vector(0.0, 1.5, 0.0));
                        ((LivingEntity)entity).addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, 40, 1));
                        entity.getWorld().spawnParticle(Particle.EXPLOSION, entity.getLocation(), 10, 0.5, 1.0, 0.5, 0.1);
                        entity.getWorld().playSound(entity.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 0.5f);
                    }
                    this.cancel();
                    return;
                }
                Location center = player.getLocation();
                for (double angle = 0.0; angle < 360.0; angle += 20.0) {
                    double x = Math.cos(Math.toRadians(angle)) * 5.0;
                    double z = Math.sin(Math.toRadians(angle)) * 5.0;
                    Location loc = center.clone().add(x, 0.5 + (double)(this.ticks % 10) * 0.2, z);
                    center.getWorld().spawnParticle(Particle.FLAME, loc, 1, 0.0, 0.0, 0.0, 0.0);
                    center.getWorld().spawnParticle(Particle.LAVA, loc, 1, 0.0, 0.0, 0.0, 0.01);
                    center.getWorld().spawnParticle(Particle.SMOKE, loc, 1, 0.1, 0.1, 0.1, 0.01);
                }
                for (Entity entity : player.getNearbyEntities(10.0, 10.0, 10.0)) {
                    if (!(entity instanceof LivingEntity) || entity == player) continue;
                    LivingEntity le = (LivingEntity)entity;
                    if (this.ticks % 20 == 0) {
                        le.setNoDamageTicks(0);
                        le.damage(1.0, (Entity)player);
                        le.getWorld().spawnParticle(Particle.DAMAGE_INDICATOR, le.getLocation(), 4, 0.3, 0.5, 0.3, 0.2);
                        le.getWorld().playSound(le.getLocation(), Sound.BLOCK_FIRE_EXTINGUISH, 0.6f, 1.6f);
                    }
                    if (this.affected.contains(le.getUniqueId())) continue;
                    le.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 140, 1));
                    le.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 140, 0));
                    le.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, 140, 0));
                    this.affected.add(le.getUniqueId());
                }
                player.getWorld().spawnParticle(Particle.CAMPFIRE_SIGNAL_SMOKE, center.clone().add(0.0, 1.0, 0.0), 2, 0.2, 0.6, 0.2, 0.01);
                player.getWorld().spawnParticle(Particle.CRIT, center.clone().add(0.0, 1.2, 0.0), 2, 0.3, 0.3, 0.3, 0.01);
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent e) {
        ItemStack item = e.getItemDrop().getItemStack();
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName() && ChatColor.stripColor((String)item.getItemMeta().getDisplayName()).contains("Thamuzel")) {
            e.setCancelled(true);
            e.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "You cannot drop this sigil!");
        }
    }
}

