/*
 * Decompiled with CFR 0.152.
 */
package fuzs.leavesbegone.helper;

import fuzs.leavesbegone.LeavesBeGone;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public final class LeavesDistanceHelper {
    private LeavesDistanceHelper() {
    }

    public static int updateDistance(BlockState blockState, BlockState neighborState, int distanceAt) {
        return LeavesDistanceHelper.mustResetDistance(blockState, neighborState, distanceAt) ? 7 : distanceAt;
    }

    private static boolean mustResetDistance(BlockState blockState, BlockState neighborState, int distanceAt) {
        if (distanceAt == 7) {
            return false;
        }
        if (!neighborState.is(BlockTags.LEAVES)) {
            return false;
        }
        if (neighborState.is(blockState.getBlock())) {
            return false;
        }
        if (blockState.is(LeavesDistanceHelper.createBlockTag(neighborState.getBlock()))) {
            return false;
        }
        return !neighborState.is(LeavesDistanceHelper.createBlockTag(blockState.getBlock()));
    }

    public static TagKey<Block> createBlockTag(Block block) {
        ResourceLocation resourceLocation = block.builtInRegistryHolder().key().location();
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)LeavesBeGone.id(resourceLocation.getNamespace() + "/" + resourceLocation.getPath()));
    }
}

