/*
 * Decompiled with CFR 0.152.
 */
package fuzs.leavesbegone.helper;

import com.mojang.serialization.Codec;
import fuzs.leavesbegone.init.ModRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.SavedTick;
import org.jetbrains.annotations.Nullable;

public final class PackedTicksHelper {
    private static final Codec<List<SavedTick<Block>>> BLOCK_TICKS_CODEC = SavedTick.codec((Codec)BuiltInRegistries.BLOCK.byNameCodec()).listOf();
    public static final Codec<ChunkAccess.PackedTicks> CODEC = BLOCK_TICKS_CODEC.xmap(blocks -> new ChunkAccess.PackedTicks(blocks, Collections.emptyList()), ChunkAccess.PackedTicks::blocks);
    @Deprecated
    public static final Codec<ChunkAccess.PackedTicks> LENIENT_CODEC = CODEC.orElse((Object)new ChunkAccess.PackedTicks(Collections.emptyList(), Collections.emptyList()));

    private PackedTicksHelper() {
    }

    public static ChunkAccess.PackedTicks getTicksForSerialization(long gametime, LevelChunkTicks<Block> levelChunkTicks) {
        Objects.requireNonNull(levelChunkTicks, "level chunk ticks is null");
        return new ChunkAccess.PackedTicks(levelChunkTicks.pack(gametime), Collections.emptyList());
    }

    public static LevelChunkTicks<Block> instantiate(ChunkAccess.PackedTicks packedTicks) {
        Objects.requireNonNull(packedTicks, "packed ticks is null");
        return new LevelChunkTicks(packedTicks.blocks());
    }

    public static void saveTickContainerFromLevel(LevelChunk levelChunk, LevelChunkTicks<Block> randomBlockTicks) {
        if ((long)randomBlockTicks.count() != 0L) {
            ChunkAccess.PackedTicks packedTicks = PackedTicksHelper.getTicksForSerialization(levelChunk.getLevel().getGameTime(), randomBlockTicks);
            ModRegistry.RANDOM_BLOCK_TICKS_ATTACHMENT_TYPE.set((Object)levelChunk, (Object)packedTicks);
        } else {
            ModRegistry.RANDOM_BLOCK_TICKS_ATTACHMENT_TYPE.set((Object)levelChunk, null);
        }
    }

    @Nullable
    public static LevelChunkTicks<Block> loadTickContainerInLevel(LevelChunk levelChunk) {
        if (ModRegistry.RANDOM_BLOCK_TICKS_ATTACHMENT_TYPE.has((Object)levelChunk)) {
            LevelChunkTicks<Block> randomBlockTicks = PackedTicksHelper.instantiate((ChunkAccess.PackedTicks)ModRegistry.RANDOM_BLOCK_TICKS_ATTACHMENT_TYPE.get((Object)levelChunk));
            ModRegistry.RANDOM_BLOCK_TICKS_ATTACHMENT_TYPE.set((Object)levelChunk, null);
            return randomBlockTicks;
        }
        return null;
    }
}

