/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import com.google.common.base.Strings;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.packets.server.SFlightValuePacket;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public abstract class FlyAbility
extends PassiveAbility2 {
    private static final ITextComponent ELEMENTAL_FLIGHT_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.elemental_flight", "Elemental Flight"));
    private static final ResourceLocation ELEMENTAL_FLIGHT_ICON = new ResourceLocation("mineminenomi", "textures/abilities/special_fly.png");
    private boolean isFlying;
    private boolean previouslyFlying = false;
    private boolean previouslyMayFly = false;
    private final AnimationComponent animationComponent = new AnimationComponent(this);

    public FlyAbility(AbilityCore ability) {
        super(ability);
        this.addComponents(this.animationComponent);
        this.setDisplayName(ELEMENTAL_FLIGHT_NAME);
        this.setDisplayIcon(ELEMENTAL_FLIGHT_ICON);
        this.addDuringPassiveEvent(this::duringPassiveEvent);
        this.addEquipEvent(this::onEquipEvent);
        this.addRemoveEvent(this::onRemoveEvent);
    }

    @Override
    public void tick(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (AbilityHelper.isInCreativeOrSpectator((LivingEntity)player)) {
            this.isFlying = false;
            return;
        }
        if (!AbilityHelper.canUseMomentumAbilities((LivingEntity)player)) {
            player.field_71075_bZ.field_75101_c = false;
            player.field_71075_bZ.field_75100_b = false;
            this.isFlying = false;
            if (player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
            }
            return;
        }
        boolean canFly = this.canUse((LivingEntity)player).isSuccess();
        if (!canFly && player.field_71075_bZ.field_75101_c) {
            player.field_71075_bZ.field_75101_c = false;
            player.field_71075_bZ.field_75100_b = false;
            this.isFlying = false;
            if (player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
            }
        }
        if (!canFly || player.func_233570_aj_()) {
            this.isFlying = false;
        }
        if (!canFly) {
            this.animationComponent.stop(entity);
        }
        super.tick(entity);
    }

    public void duringPassiveEvent(LivingEntity entity) {
        boolean flight;
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        this.isFlying = player.field_71075_bZ.field_75100_b;
        boolean bl = flight = !player.func_70644_a((Effect)ModEffects.ABILITY_OFF.get()) && !AbilityHelper.isWeakenedByKairosekiOrWater((LivingEntity)player);
        if (!player.field_70170_p.field_72995_K) {
            WyNetwork.sendTo(new SFlightValuePacket(flight), player);
            player.field_71075_bZ.field_75101_c = flight;
            boolean isNormal = Strings.isNullOrEmpty((String)DevilFruitCapability.get((LivingEntity)player).getZoanPoint());
            if (this.isFlying && isNormal) {
                this.animationComponent.start(entity, ModAnimations.SPECIAL_FLY);
                WyHelper.spawnParticleEffect(this.getParticleEffects().get(), (Entity)player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            } else {
                this.animationComponent.stop(entity);
            }
        }
        if (this.isFlying) {
            double maxDifference = this.getHeightDifference(player);
            float speedMultiplier = this.getSpeedMultiplier(player);
            AbilityHelper.setDeltaMovement((Entity)player, player.func_213322_ci().func_216372_d((double)speedMultiplier, (double)(speedMultiplier - 0.25f), (double)speedMultiplier));
            if (!player.field_70170_p.field_72995_K && maxDifference != 0.0 && !CommonConfig.INSTANCE.hasYRestrictionRemoved()) {
                boolean heightCheck = DevilFruitHelper.flyingAtMaxHeight((LivingEntity)player, maxDifference);
                DevilFruitHelper.vanillaFlightThreshold((LivingEntity)player, heightCheck ? 256 : (int)player.func_226278_cu_() - 1);
            }
        }
        if (!flight) {
            player.field_71075_bZ.field_75100_b = false;
        }
    }

    public void onEquipEvent(LivingEntity entity, IAbility ability) {
        if (entity instanceof PlayerEntity && !AbilityHelper.isInCreativeOrSpectator(entity)) {
            this.previouslyFlying = ((PlayerEntity)entity).field_71075_bZ.field_75100_b;
            this.previouslyMayFly = ((PlayerEntity)entity).field_71075_bZ.field_75101_c;
        }
    }

    public void onRemoveEvent(LivingEntity entity, IAbility ability) {
        if (entity instanceof PlayerEntity && !AbilityHelper.isInCreativeOrSpectator(entity)) {
            ((PlayerEntity)entity).field_71075_bZ.field_75100_b = this.previouslyFlying;
            ((PlayerEntity)entity).field_71075_bZ.field_75101_c = this.previouslyMayFly;
        }
    }

    public abstract Supplier<ParticleEffect<?>> getParticleEffects();

    public abstract int getHeightDifference(PlayerEntity var1);

    public abstract float getSpeedMultiplier(PlayerEntity var1);

    @Override
    public AbilityUseResult canUse(LivingEntity entity) {
        if (AbilityHelper.isInCreativeOrSpectator(entity)) {
            return AbilityUseResult.fail(null);
        }
        if (entity.func_110148_a((Attribute)ModAttributes.JUMP_HEIGHT.get()).func_111126_e() < 0.0) {
            return AbilityUseResult.fail(null);
        }
        return super.canUse(entity);
    }
}

