/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GrabEntityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class GrabLockAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "grab_lock", new Pair[]{ImmutablePair.of((Object)"Grabs an opponent from the back and keeps them pinned like that.", null)});
    private static final int HOLD_TIME = 40;
    private static final int PULL_TIME = 200;
    private static final float COOLDOWN = 200.0f;
    public static final AbilityCore<GrabLockAbility> INSTANCE = new AbilityCore.Builder<GrabLockAbility>("Grab Lock", AbilityCategory.STYLE, GrabLockAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), ContinuousComponent.getTooltip(40.0f)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final GrabEntityComponent grabComponent = new GrabEntityComponent(this, true, true, true, 2.0f).addPullStartEvent(this::onPullStart).addPullEndEvent(this::onPullEnd).addGrabEvent(this::grabEvent).addReleaseEvent(this::releaseEvent);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent(this).addTryHitEvent(this::tryHitEvent).addOnHitEvent(this::onHitEvent);
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);

    public GrabLockAbility(AbilityCore<GrabLockAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.animationComponent, this.grabComponent, this.hitTriggerComponent, this.poolComponent);
        this.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private HitTriggerComponent.HitResult tryHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (!this.continuousComponent.isContinuous() || this.grabComponent.hasGrabbedEntity()) {
            return HitTriggerComponent.HitResult.PASS;
        }
        return HitTriggerComponent.HitResult.HIT;
    }

    private boolean onHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.grabComponent.grabManually(entity, target)) {
            this.grabComponent.startPulling(entity);
        }
        target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 1));
        return false;
    }

    public void onPullStart(LivingEntity entity, IAbility ability) {
        this.continuousComponent.setThresholdTime(entity, 200.0f);
    }

    public void onPullEnd(LivingEntity entity, IAbility ability) {
        if (this.grabComponent.canContinueGrab(entity)) {
            this.continuousComponent.setThresholdTime(entity, 40.0f);
        }
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.grabComponent.getState() == GrabEntityComponent.GrabState.IDLE) {
            return;
        }
        if (super.canUse(entity).isFail() || !this.grabComponent.canContinueGrab(entity)) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        LivingEntity target = this.grabComponent.getGrabbedEntity();
        if (target != null) {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1));
            target.func_195064_c(new EffectInstance((Effect)ModEffects.GRABBED.get(), 5, 3));
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.grabComponent.release(entity);
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    private boolean grabEvent(LivingEntity entity, LivingEntity target, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.POINT_ARMS);
        return true;
    }

    private void releaseEvent(LivingEntity entity, LivingEntity target, IAbility ability) {
    }
}

