/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.DropHitAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;

public class LeapAbility
extends DropHitAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "leap", new Pair[]{ImmutablePair.of((Object)"Leaps at the enemy and damages all nearby entities on landing.", null)});
    private static final float COOLDOWN = 120.0f;
    private static final float DAMAGE = 10.0f;
    private static final float RANGE = 2.5f;
    public static final AbilityCore<LeapAbility> INSTANCE = new AbilityCore.Builder<LeapAbility>("Leap", AbilityCategory.STYLE, LeapAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(120.0f), DealDamageComponent.getTooltip(10.0f), RangeComponent.getTooltip(2.5f, RangeComponent.RangeType.AOE)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private double leapHeight = 1.0;
    private double leapDistance = 1.4;

    public LeapAbility(AbilityCore<LeapAbility> core) {
        super((AbilityCore<? extends DropHitAbility2>)core);
        this.addComponents(this.dealDamageComponent, this.rangeComponent);
        this.continuousComponent.addStartEvent(100, this::startContinuityEvent);
        this.continuousComponent.addEndEvent(100, this::endContinuityEvent);
    }

    public double getLeapHeight() {
        return this.leapHeight;
    }

    public void setLeapHeight(double height) {
        this.leapHeight = height;
    }

    public double getLeapDistance() {
        return this.leapDistance;
    }

    public void setLeapDistance(double distance) {
        this.leapDistance = distance;
    }

    @Override
    public void onLanding(LivingEntity entity) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 2.5f);
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
            this.dealDamageComponent.hurtTarget(entity, target, 10.0f);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 120.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        Vector3d speed = entity.func_70040_Z().func_216372_d(this.leapDistance, 1.0, this.leapDistance);
        AbilityHelper.setDeltaMovement((Entity)entity, speed.field_72450_a, this.leapHeight, speed.field_72449_c);
    }
}

