/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.TargetHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;

public class OneTwoJangoAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "one_two_jango", new Pair[0]);
    private static final int CHARGE_TIME = 60;
    private static final int COOLDOWN = 200;
    public static final int RANGE = 15;
    public static final AbilityCore<OneTwoJangoAbility> INSTANCE = new AbilityCore.Builder<OneTwoJangoAbility>("One Two Jango", AbilityCategory.STYLE, OneTwoJangoAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), RangeComponent.getTooltip(15.0f, RangeComponent.RangeType.AOE)).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(100, this::startChargeEvent).addEndEvent(100, this::endChargeEvent);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private boolean canAffectSelf = false;

    public OneTwoJangoAbility(AbilityCore<OneTwoJangoAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.animationComponent, this.rangeComponent);
        this.addCanUseCheck(OneTwoJangoAbility::canUse);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 60.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.ONE_TWO_JANGO, 60);
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, entity.func_233580_cy_(), 15.0f, TargetsPredicate.EVERYTHING);
        if (this.canAffectSelf) {
            targets.add(entity);
        }
        for (LivingEntity target : targets) {
            if (entity != target && (!(target instanceof PlayerEntity) || !TargetHelper.isEntityInView(target, (Entity)entity, 60.0f)) && (!(target instanceof MobEntity) || !GoalUtil.canSee((MobEntity)target, entity))) continue;
            target.func_195064_c(new EffectInstance((Effect)ModEffects.UNCONSCIOUS.get(), 60, 0));
        }
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    public void setAffectSelf(boolean canAffectSelf) {
        this.canAffectSelf = canAffectSelf;
    }

    public static AbilityUseResult canUse(LivingEntity entity, IAbility ability) {
        if (entity.func_184614_ca().func_190926_b() || !entity.func_184614_ca().func_77973_b().equals(ModWeapons.CHAKRAM.get())) {
            return AbilityUseResult.fail(null);
        }
        return AbilityUseResult.success();
    }
}

