/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class PearlFireAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "pearl_fire", new Pair[]{ImmutablePair.of((Object)"Sets the pearl armor on fire causing any enemy that hits you to take damage and any enemy you hit to be set on fire.", null)});
    private static final int HOLD_TIME = 1200;
    private static final int MIN_COOLDOWN = 100;
    private static final int MAX_COOLDOWN = 1300;
    public static final AbilityCore<PearlFireAbility> INSTANCE = new AbilityCore.Builder<PearlFireAbility>("Pearl Fire", AbilityCategory.EQUIPMENT, PearlFireAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f, 1300.0f), ContinuousComponent.getTooltip(1200.0f)).setUnlockCheck(PearlFireAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this).addOnHurtEvent(this::damageTakenEvent);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent(this).addOnHitEvent(this::onHit).addTryHitEvent(this::tryHitEvent);

    public PearlFireAbility(AbilityCore<PearlFireAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.damageTakenComponent, this.dealDamageComponent, this.hitTriggerComponent);
        super.addCanUseCheck(this::canUse);
        super.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 1200.0f);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                double x = WyHelper.randomDouble();
                double y = WyHelper.randomDouble() / 3.0;
                double z = WyHelper.randomDouble();
                SimpleParticleData data = new SimpleParticleData((ParticleType)ModParticleTypes.MERA.get());
                data.setLife(35);
                data.setSize(1.0f + entity.func_70681_au().nextFloat());
                data.setMotion(x / 200.0, 0.02, z / 200.0);
                data.setColor(1.0f, 1.0f, 1.0f, 0.4f);
                WyHelper.spawnParticles(data, (ServerWorld)entity.field_70170_p, entity.func_226277_ct_() + x, entity.func_226278_cu_() + y + 0.5, entity.func_226281_cx_() + z);
                WyHelper.spawnParticles(data, (ServerWorld)entity.field_70170_p, entity.func_226277_ct_() + x, entity.func_226278_cu_() + y + 1.5, entity.func_226281_cx_() + z);
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 100.0f + this.continuousComponent.getContinueTime());
    }

    private HitTriggerComponent.HitResult tryHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (!this.continuousComponent.isContinuous()) {
            return HitTriggerComponent.HitResult.PASS;
        }
        return HitTriggerComponent.HitResult.HIT;
    }

    public boolean onHit(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        AbilityHelper.setSecondsOnFireBy((Entity)target, 2, entity);
        return true;
    }

    private float damageTakenEvent(LivingEntity user, IAbility ability, DamageSource damageSource, float damage) {
        if (this.continuousComponent.isContinuous() && damageSource.func_76364_f() != null && damageSource.func_76364_f() instanceof LivingEntity) {
            this.dealDamageComponent.hurtTarget(user, (LivingEntity)damageSource.func_76364_f(), damage / 3.0f);
            return damage - damage / 3.0f;
        }
        return damage;
    }

    private AbilityUseResult canUse(LivingEntity entity, IAbility ability) {
        if (PearlFireAbility.hasArmorSetEquipped(entity)) {
            return AbilityUseResult.success();
        }
        return AbilityUseResult.fail(null);
    }

    private static boolean canUnlock(LivingEntity entity) {
        return PearlFireAbility.hasArmorSetEquipped(entity);
    }

    private static boolean hasArmorSetEquipped(LivingEntity entity) {
        ItemStack headStack = entity.func_184582_a(EquipmentSlotType.HEAD);
        if (headStack.func_190926_b() || headStack.func_77973_b() != ModArmors.PEARL_HAT.get()) {
            return false;
        }
        ItemStack chestStack = entity.func_184582_a(EquipmentSlotType.CHEST);
        if (chestStack.func_190926_b() || chestStack.func_77973_b() != ModArmors.PEARL_ARMOR.get()) {
            return false;
        }
        ItemStack legsStack = entity.func_184582_a(EquipmentSlotType.LEGS);
        return !legsStack.func_190926_b() && legsStack.func_77973_b() == ModArmors.PEARL_LEGS.get();
    }
}

