/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.animations.AnimationId;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.math.VectorHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ShakushiAbility
extends Ability {
    private static final int COOLDOWN = 400;
    private static final int CHARGE_TIME = 40;
    private static final int RANGE = 10;
    private static final int DAMAGE = 30;
    private static final int STACKS = 5;
    private static final TargetsPredicate TARGETS_PREDICATE = new TargetsPredicate();
    private static final AnimationId[] HIT_ANIMATIONS = new AnimationId[]{ModAnimations.CROSSED_ATTACK, ModAnimations.BODY_ROTATION_WIDE_ARMS};
    public static final AbilityCore<ShakushiAbility> INSTANCE = new AbilityCore.Builder<ShakushiAbility>("Shakushi", AbilityCategory.STYLE, ShakushiAbility::new).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(400.0f), ChargeComponent.getTooltip(40.0f), RangeComponent.getTooltip(10.0f, RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip(30.0f), StackComponent.getTooltip(5)).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(SourceType.SLASH).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addTickEvent(this::tickChargeEvent).addEndEvent(this::endChargeEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final StackComponent stackComponent = new StackComponent(this);

    public ShakushiAbility(AbilityCore<ShakushiAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.rangeComponent, this.chargeComponent, this.dealDamageComponent, this.animationComponent, this.stackComponent);
        this.addUseEvent(this::useEvent);
        this.addTickEvent(this::tickEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (this.chargeComponent.isCharging()) {
            this.chargeComponent.stopCharging(entity);
            this.cooldownComponent.startCooldown(entity, 400.0f);
            return;
        }
        this.stackComponent.setDefaultStacks(5);
        this.stackComponent.setStacks(entity, ability, 5);
        this.animationComponent.start(entity, ModAnimations.LOW_SWING_ARMS, 39);
        this.chargeComponent.startCharging(entity, 40.0f);
    }

    private void tickEvent(LivingEntity entity, IAbility ability) {
        if (!this.isCharging() && this.stackComponent.getStacks() > 0 && this.stackComponent.getStacks() < this.stackComponent.getDefaultStacks()) {
            this.chargeComponent.startCharging(entity, 20.0f);
        }
    }

    private void tickChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.stackComponent.getStacks() > 0 && this.stackComponent.getStacks() < this.stackComponent.getDefaultStacks() && this.chargeComponent.getChargePercentage() >= 0.5f && !entity.func_70644_a((Effect)ModEffects.VANISH.get())) {
            BlockPos newPos;
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.VANISH.get(), (int)this.chargeComponent.getMaxChargeTime(), 0, false, false));
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), (int)this.chargeComponent.getMaxChargeTime(), 0, false, false));
            LivingEntity target = this.getNearbyTarget(entity);
            if (target != null && (newPos = WyHelper.findValidGroundLocation((Entity)entity, entity.func_233580_cy_(), 5, 0)) != null) {
                entity.func_223102_j((double)newPos.func_177958_n(), (double)newPos.func_177956_o(), (double)newPos.func_177952_p());
            }
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            this.stackComponent.addStacks(entity, ability, -1);
            entity.func_195063_d((Effect)ModEffects.VANISH.get());
            LivingEntity target = this.getNearbyTarget(entity);
            if (target != null && target.func_70089_S()) {
                Vector3d targetLook = VectorHelper.calculateViewVectorFromBodyRot(target.field_70125_A, target.field_70761_aq).func_216372_d(-2.0, 0.0, -2.0);
                Vector3d newPos = target.func_213303_ch().func_178787_e(targetLook);
                entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 0, false, false));
                WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.GEPPO.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_() + 0.5, entity.func_226281_cx_());
                entity.func_223102_j(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
                entity.func_200602_a(EntityAnchorArgument.Type.EYES, target.func_213303_ch().func_72441_c(0.0, (double)target.func_70047_e(), 0.0));
                List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, target.func_233580_cy_(), 2.0f);
                for (LivingEntity target2 : targets) {
                    this.dealDamageComponent.hurtTarget(entity, target2, 30.0f);
                    WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197603_N, (ServerWorld)entity.field_70170_p, target2.func_226277_ct_(), target2.func_226278_cu_() + (double)target2.func_70047_e(), target2.func_226281_cx_());
                }
                AnimationId anim = HIT_ANIMATIONS[entity.func_70681_au().nextInt(HIT_ANIMATIONS.length)];
                this.animationComponent.start(entity, anim, 7);
                entity.func_226292_a_(Hand.MAIN_HAND, true);
            }
            if (this.stackComponent.getStacks() <= 0 || target == null) {
                this.stackComponent.revertStacksToDefault(entity, this);
                this.cooldownComponent.startCooldown(entity, 400.0f);
            }
        }
    }

    @Nullable
    private LivingEntity getNearbyTarget(LivingEntity entity) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 10.0f, TARGETS_PREDICATE);
        if (targets.size() > 0) {
            Collections.shuffle(targets);
            return targets.get(0);
        }
        return null;
    }
}

