/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;

public abstract class SourceImmunityAbility
extends PassiveAbility2 {
    public static final SourceImmunityInfo EMPTY = new SourceImmunityInfo();
    public static final SourceImmunityInfo FIRE_IMMUNITY = new SourceImmunityInfo().addSourceRule(ds -> ds.func_76347_k() && ds != DamageSource.field_76371_c && ds != ModDamageSource.SUN_INCINERATION);
    public static final SourceImmunityInfo MAGMA_IMMUNITY = new SourceImmunityInfo().addSourceRule(ds -> ds.func_76347_k() && ds != ModDamageSource.SUN_INCINERATION);
    public static final SourceImmunityInfo LIGHTNING_IMMUNITY = new SourceImmunityInfo().addSourceImmunities(DamageSource.field_180137_b);
    protected final SourceImmunityInfo immunityInfo;
    protected final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this).addOnAttackEvent(this::damageCheck);

    public SourceImmunityAbility(AbilityCore<SourceImmunityAbility> ability, @Nullable SourceImmunityInfo immunityInfo) {
        super(ability);
        this.immunityInfo = immunityInfo == null ? EMPTY : immunityInfo;
        this.addComponents(this.damageTakenComponent);
    }

    public abstract boolean isDamageTaken(LivingEntity var1, DamageSource var2, float var3);

    public float damageCheck(LivingEntity user, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.isDamageTaken(user, damageSource, damage)) {
            return 0.0f;
        }
        if (this.immunityInfo.isImmune(damageSource)) {
            return 0.0f;
        }
        return damage;
    }

    public static class SourceImmunityInfo {
        private static final List<DamageSource> DEFAULT_LOGIA_IMMUNITIES = Arrays.asList(DamageSource.field_76367_g, DamageSource.field_220302_v, DamageSource.field_82728_o, DamageSource.field_188406_j, DamageSource.field_76379_h, DamageSource.field_82729_p);
        private ArrayList<DamageSource> sourceImmunities = new ArrayList();
        private ArrayList<Pair<DamageSource, Integer>> sourceResistances = new ArrayList();
        private ArrayList<Predicate<DamageSource>> sourceRules = new ArrayList();

        public SourceImmunityInfo() {
            this.addSourceImmunities(DEFAULT_LOGIA_IMMUNITIES.toArray(new DamageSource[0]));
        }

        public boolean isImmune(DamageSource source) {
            boolean hasRulePass = this.sourceRules.stream().anyMatch(p -> p.test(source));
            boolean hasImmunity = this.sourceImmunities.contains(source);
            return hasRulePass || hasImmunity;
        }

        public <T extends SourceImmunityInfo> T addSourceRule(Predicate<DamageSource> rule) {
            this.sourceRules.add(rule);
            return (T)this;
        }

        public <T extends SourceImmunityInfo> T addSourceImmunities(DamageSource ... sources) {
            this.sourceImmunities.addAll(Arrays.asList(sources));
            return (T)this;
        }

        public <T extends SourceImmunityInfo> T addSourceResistance(DamageSource source, int resistance) {
            this.sourceResistances.add((Pair<DamageSource, Integer>)Pair.of((Object)source, (Object)resistance));
            return (T)this;
        }
    }
}

