/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import java.util.List;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.math.VectorHelper;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class StealthFootAbility
extends Ability {
    private static final int CHARGE_TIME = 20;
    private static final int COOLDOWN = 100;
    private static final int RANGE = 10;
    private static final int DAMAGE = 20;
    public static final AbilityCore<StealthFootAbility> INSTANCE = new AbilityCore.Builder<StealthFootAbility>("Stealth Foot", AbilityCategory.STYLE, StealthFootAbility::new).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f), ChargeComponent.getTooltip(20.0f), RangeComponent.getTooltip(10.0f, RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip(20.0f)).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(SourceType.SLASH).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addEndEvent(this::endChargeEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private LivingEntity target;

    public StealthFootAbility(AbilityCore<StealthFootAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.rangeComponent, this.chargeComponent, this.dealDamageComponent, this.animationComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (this.chargeComponent.isCharging()) {
            return;
        }
        List<LivingEntity> targets = this.rangeComponent.getTargetsInLine(entity, 10.0f, 2.0f);
        if (targets.size() > 0) {
            this.target = targets.get(0);
        }
        if (this.target != null) {
            Vector3d targetLook = VectorHelper.calculateViewVectorFromBodyRot(this.target.field_70125_A, this.target.field_70761_aq).func_216372_d(-2.0, 0.0, -2.0);
            Vector3d newPos = this.target.func_213303_ch().func_178787_e(targetLook);
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.VANISH.get(), 10, 0, false, false));
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), (int)this.chargeComponent.getMaxChargeTime(), 0, false, false));
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.GEPPO.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_() + 0.5, entity.func_226281_cx_());
            entity.func_223102_j(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
            entity.func_200602_a(EntityAnchorArgument.Type.EYES, this.target.func_213303_ch().func_72441_c(0.0, (double)this.target.func_70047_e(), 0.0));
            this.chargeComponent.startCharging(entity, 20.0f);
        } else {
            this.cooldownComponent.startCooldown(entity, 100.0f);
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && this.target != null && this.target.func_70089_S() && Math.abs(this.target.func_70032_d((Entity)entity)) < 5.0f) {
            this.animationComponent.start(entity, ModAnimations.CROSSED_ATTACK, 7);
            entity.func_226292_a_(Hand.MAIN_HAND, true);
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, this.target.func_233580_cy_(), 2.0f);
            for (LivingEntity target : targets) {
                this.dealDamageComponent.hurtTarget(entity, target, 20.0f);
                WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197603_N, (ServerWorld)entity.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_() + (double)target.func_70047_e(), target.func_226281_cx_());
            }
        }
        this.target = null;
        this.cooldownComponent.startCooldown(entity, 100.0f);
    }
}

