/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class TailSpinAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "tail_spin", new Pair[]{ImmutablePair.of((Object)"Spins around hitting all nearby enemies with the user's tail.", null)});
    private static final int COOLDOWN = 200;
    private static final float RANGE = 5.5f;
    private static final float DAMAGE = 10.0f;
    public static final AbilityCore<TailSpinAbility> INSTANCE = new AbilityCore.Builder<TailSpinAbility>("Tail Spin", AbilityCategory.RACIAL, TailSpinAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), RangeComponent.getTooltip(5.5f, RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip(10.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);

    public TailSpinAbility(AbilityCore<TailSpinAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.animationComponent, this.rangeComponent, this.dealDamageComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        List<LivingEntity> list = this.rangeComponent.getTargetsInArea(entity, entity.func_233580_cy_(), 5.5f);
        this.animationComponent.start(entity, ModAnimations.YAW_SPIN, 10);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.SPIN.get(), SoundCategory.PLAYERS, 2.0f, 0.75f + entity.func_70681_au().nextFloat() / 4.0f);
        for (LivingEntity target : list) {
            if (!this.dealDamageComponent.hurtTarget(entity, target, 10.0f)) continue;
            Vector3d dist = target.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72441_c(0.0, -1.0, 0.0);
            double speedReduction = 2.0;
            double xSpeed = -dist.field_72450_a / speedReduction;
            double zSpeed = -dist.field_72449_c / speedReduction;
            AbilityHelper.setDeltaMovement((Entity)target, -xSpeed, 0.1f, -zSpeed);
        }
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }
}

