/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.BlockPlacingHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class TestAbility
extends Ability {
    public static final AbilityCore<TestAbility> INSTANCE = new AbilityCore.Builder<TestAbility>("Test", AbilityCategory.DEVIL_FRUITS, TestAbility::new).build();
    protected final ContinuousComponent continuousComponent = new ContinuousComponent(this);
    private static final BlockPos POS = new BlockPos(-655, 90, -95);
    private Set<Long> blocks = new HashSet<Long>();
    private BlockPlacingHelper placeHelper = new BlockPlacingHelper();
    private long startTime;
    private int total;
    private int spawned;
    private Iterator<Long> iter;

    public TestAbility(AbilityCore<TestAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent);
        this.continuousComponent.addTickEvent(this::tickCotinuityEvent);
        this.continuousComponent.addEndEvent(this::endContinuityEvent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.continuousComponent.triggerContinuity(entity);
    }

    private void tickCotinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.PIKA_CHARGING.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
    }

    public static Set<Long> createCenteredFilledCube(World world, BlockPos origin, int sizeX, int sizeY, int sizeZ, BlockState state, int flag, @Nullable BlockProtectionRule rule) {
        int x0 = origin.func_177958_n();
        int y0 = origin.func_177956_o();
        int z0 = origin.func_177952_p();
        boolean isNegative = sizeY < 0;
        sizeY = Math.abs(sizeY);
        int actualXSize = (int)Math.ceil((double)sizeX / 2.0);
        int actualZSize = (int)Math.ceil((double)sizeZ / 2.0);
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        HashSet<Long> blocks = new HashSet<Long>();
        for (int x = -actualXSize; x < actualXSize; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                for (int z = -actualZSize; z < actualZSize; ++z) {
                    mutpos.func_181079_c(x0 + x, isNegative ? y0 - y : y0 + y, z0 + z);
                    long l = mutpos.func_218275_a();
                    blocks.add(l);
                }
            }
        }
        return blocks;
    }

    public static enum Mode {
        FIRST,
        SECOND,
        THIRD;

    }
}

