/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.entities.NetEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.items.NetItem;

public class WootzNetLauncherAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "wootz_net_launcher", new Pair[]{ImmutablePair.of((Object)"Shoots a net from one of the many guns hidden within the armor.", null)});
    private static final int COOLDOWN = 600;
    public static final AbilityCore<WootzNetLauncherAbility> INSTANCE = new AbilityCore.Builder<WootzNetLauncherAbility>("Wootz Net Launcher", AbilityCategory.EQUIPMENT, WootzNetLauncherAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(600.0f)).setUnlockCheck(WootzNetLauncherAbility::canUnlock).build();
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private ItemStack netStack = ItemStack.field_190927_a;

    public WootzNetLauncherAbility(AbilityCore<WootzNetLauncherAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.animationComponent);
        this.addCanUseCheck(this::canUse);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!(this.netStack.func_77973_b() instanceof NetItem)) {
            return;
        }
        NetItem netItem = (NetItem)this.netStack.func_77973_b();
        this.animationComponent.start(entity, ModAnimations.MH5_CHARGING, 7);
        Vector3d look = entity.func_70040_Z();
        NetEntity netEntity = NetEntity.createFromItem(entity.field_70170_p, entity, netItem);
        netEntity.func_70107_b(entity.func_226277_ct_() + look.field_72450_a, entity.func_226280_cw_() + look.field_72448_b, entity.func_226281_cx_() + look.field_72449_c);
        netEntity.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 1.25f, 0.0f);
        entity.field_70170_p.func_217376_c((Entity)netEntity);
        this.netStack.func_190918_g(1);
        this.cooldownComponent.startCooldown(entity, 600.0f);
    }

    private void findNewStack(LivingEntity entity) {
        List<ItemStack> inventory = ItemsHelper.getAllInventoryItems(entity);
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = inventory.get(i);
            if (stack == null || stack.func_190926_b() || !(stack.func_77973_b() instanceof NetItem)) continue;
            this.netStack = stack;
            break;
        }
    }

    private AbilityUseResult canUse(LivingEntity entity, IAbility ability) {
        if (!WootzNetLauncherAbility.hasArmorSetEquipped(entity)) {
            return AbilityUseResult.fail(null);
        }
        this.findNewStack(entity);
        if (this.netStack.func_190926_b()) {
            return AbilityUseResult.fail(null);
        }
        return AbilityUseResult.success();
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            return false;
        }
        return WootzNetLauncherAbility.hasArmorSetEquipped(entity);
    }

    private static boolean hasArmorSetEquipped(LivingEntity entity) {
        ItemStack chestStack = entity.func_184582_a(EquipmentSlotType.CHEST);
        return !chestStack.func_190926_b() && chestStack.func_77973_b() == ModArmors.WOOTZ_STEEL_ARMOR.get();
    }
}

