/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.ArtOfWeatherHelper;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.ChargedTempoAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.WeatherBallKind;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModQuests;

public class CycloneTempo
extends ChargedTempoAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "cyclone_tempo", new Pair[]{ImmutablePair.of((Object)"Used to create a small cyclone surrounding the user, pushes enemies away from the user while also providing a small protection against physical damage", null)});
    private static final float RANGE = 6.0f;
    private static final int HOLD_TIME = 200;
    public static final AbilityCore<CycloneTempo> INSTANCE = new AbilityCore.Builder<CycloneTempo>("Cyclone Tempo", AbilityCategory.STYLE, AbilityType.PASSIVE, CycloneTempo::new).addDescriptionLine(CHARGED_TEMPO_DESCRIPTION).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, ContinuousComponent.getTooltip(200.0f), RangeComponent.getTooltip(6.0f, RangeComponent.RangeType.AOE)).setUnlockCheck(CycloneTempo::canUnlock).build();
    private final RangeComponent rangeComponent = new RangeComponent(this);

    public CycloneTempo(AbilityCore<CycloneTempo> core) {
        super((AbilityCore)core);
        this.addComponents(this.rangeComponent);
        this.addCanUseCheck(ArtOfWeatherHelper::needsSorceryClimaTact);
    }

    @Override
    public WeatherBallKind[] getTempoOrder() {
        return new WeatherBallKind[]{WeatherBallKind.COOL, WeatherBallKind.COOL, WeatherBallKind.COOL};
    }

    @Override
    public void useTempo(LivingEntity entity) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.CYCLONE_TEMPO.get(), 200, 0));
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isWeatherWizard() && questProps.hasFinishedQuest(ModQuests.ART_OF_WEATHER_TRIAL_04);
    }
}

