/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.ChargedTempoAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.WeatherBallKind;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.artofweather.MirageTempoCloudEntity;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class FogTempo
extends ChargedTempoAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "fog_tempo", new Pair[]{ImmutablePair.of((Object)"Creates a thick fog at the user's position, blinding all nearby enemies as well", null)});
    public static final AbilityCore<FogTempo> INSTANCE = new AbilityCore.Builder<FogTempo>("Fog Tempo", AbilityCategory.STYLE, AbilityType.PASSIVE, FogTempo::new).addDescriptionLine(CHARGED_TEMPO_DESCRIPTION).addDescriptionLine(DESCRIPTION).setUnlockCheck(FogTempo::canUnlock).build();

    public FogTempo(AbilityCore<FogTempo> core) {
        super((AbilityCore)core);
    }

    @Override
    public WeatherBallKind[] getTempoOrder() {
        return new WeatherBallKind[]{WeatherBallKind.HEAT, WeatherBallKind.HEAT, WeatherBallKind.COOL};
    }

    @Override
    public void useTempo(LivingEntity entity) {
        MirageTempoCloudEntity smokeCloud = new MirageTempoCloudEntity(entity.field_70170_p);
        smokeCloud.setLife(300);
        smokeCloud.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_() + 1.0, entity.func_226281_cx_(), 0.0f, 0.0f);
        AbilityHelper.setDeltaMovement(smokeCloud, 0.0, 0.0, 0.0);
        smokeCloud.setThrower(entity);
        entity.field_70170_p.func_217376_c((Entity)smokeCloud);
        List<LivingEntity> targets = WyHelper.getNearbyLiving(entity.func_213303_ch(), (IWorld)entity.field_70170_p, 10.0, ModEntityPredicates.getEnemyFactions(entity));
        for (LivingEntity target : targets) {
            target.func_195064_c(new EffectInstance(Effects.field_76440_q, 200, 1));
        }
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isWeatherWizard() && questProps.hasFinishedQuest(ModQuests.ART_OF_WEATHER_TRIAL_02);
    }
}

