/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.ArtOfWeatherHelper;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.ChargedTempoAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.WeatherBallKind;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.items.weapons.ClimaTactItem;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ThunderLanceTempo
extends ChargedTempoAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "thunder_lance_tempo", new Pair[]{ImmutablePair.of((Object)"Creates a lighting bolt that goes directly to the area the user is pointing at, exploding on impact and hurting entities in its path", null)});
    public static final AbilityDescriptionLine.IDescriptionLine CUSTOM_CHARGE_TIME = (entity, ability) -> {
        if (!ItemsHelper.isClimaTact(entity.func_184614_ca())) {
            return null;
        }
        ClimaTactItem climaTact = (ClimaTactItem)entity.func_184614_ca().func_77973_b();
        int chargeTime = (4 - climaTact.getLevel()) * 4 * 20;
        return ChargeComponent.getTooltip(chargeTime).expand(entity, ability);
    };
    private static final float DAMAGE = 60.0f;
    private static final float MAX_DISTANCE = 80.0f;
    public static final AbilityCore<ThunderLanceTempo> INSTANCE = new AbilityCore.Builder<ThunderLanceTempo>("Thunder Lance Tempo", AbilityCategory.STYLE, AbilityType.PASSIVE, ThunderLanceTempo::new).addDescriptionLine(CHARGED_TEMPO_DESCRIPTION).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CUSTOM_CHARGE_TIME, DealDamageComponent.getTooltip(60.0f)).setSourceHakiNature(SourceHakiNature.IMBUING).setUnlockCheck(ThunderLanceTempo::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addTickEvent(100, this::duringChargeEvent).addEndEvent(100, this::endChargeEvent);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private Vector3d pos;

    public ThunderLanceTempo(AbilityCore<ThunderLanceTempo> core) {
        super((AbilityCore)core);
        this.addComponents(this.chargeComponent, this.dealDamageComponent);
        this.addCanUseCheck(ArtOfWeatherHelper::needsClimaTact);
    }

    @Override
    public WeatherBallKind[] getTempoOrder() {
        return new WeatherBallKind[]{WeatherBallKind.THUNDER, WeatherBallKind.THUNDER, WeatherBallKind.THUNDER};
    }

    @Override
    public void useTempo(LivingEntity entity) {
        if (entity.func_184614_ca().func_190926_b() || this.chargeComponent.isCharging()) {
            return;
        }
        ClimaTactItem climaTact = (ClimaTactItem)entity.func_184614_ca().func_77973_b();
        int chargeTime = (4 - climaTact.getLevel()) * 4 * 20;
        this.chargeComponent.startCharging(entity, chargeTime);
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        BlockRayTraceResult mop = WyHelper.rayTraceBlocks((Entity)entity, 80.0);
        this.pos = mop.func_216347_e();
        double i = this.pos.field_72450_a;
        double j = this.pos.field_72448_b;
        double k = this.pos.field_72449_c;
        if (entity.field_70173_aa % 2 == 0) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.THUNDER_LANCE.get(), (Entity)entity, i, j, k);
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
        int beamLength = 2;
        LightningEntity bolt = new LightningEntity((Entity)entity, beamLength + 100, 6.0f, INSTANCE);
        bolt.setMaxLife(10);
        bolt.setTargetTimeToReset(20);
        bolt.setDamage(0.0f);
        bolt.setLightningMimic(false);
        bolt.disableExplosionKnockback();
        bolt.setColor(new Color(253, 208, 35, 205));
        bolt.setExplosion(1, false, 1.0f);
        bolt.setBoxSizeDivision(0.225f);
        bolt.setAngle(20);
        bolt.setBranches(2);
        int segments = 5;
        bolt.setSegments((int)((double)segments + WyHelper.randomWithRange(-segments / 2, segments / 2)));
        entity.field_70170_p.func_217376_c((Entity)bolt);
        ArrayList<LivingEntity> hurt = new ArrayList<LivingEntity>();
        float f = 0.0f;
        while (f < 1.0f) {
            double x = MathHelper.func_219803_d((double)f, (double)entity.func_213303_ch().func_82615_a(), (double)this.pos.func_82615_a());
            double y = MathHelper.func_219803_d((double)f, (double)entity.func_213303_ch().func_82617_b(), (double)this.pos.func_82617_b());
            double z = MathHelper.func_219803_d((double)f, (double)entity.func_213303_ch().func_82616_c(), (double)this.pos.func_82616_c());
            Vector3d pos = new Vector3d(x, y, z);
            List<LivingEntity> targets = WyHelper.getNearbyLiving(pos, (IWorld)entity.field_70170_p, 3.0, ModEntityPredicates.getEnemyFactions(entity));
            for (LivingEntity target : targets) {
                if (!entity.func_70685_l((Entity)target) || hurt.contains(target)) continue;
                ModDamageSource source = (ModDamageSource)this.dealDamageComponent.getDamageSource(entity);
                source.bypassLogia().setPiercing(0.75f);
                this.dealDamageComponent.hurtTarget(entity, target, 60.0f, source);
                hurt.add(target);
            }
            f = (float)((double)f + 0.13);
        }
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isWeatherWizard() && questProps.hasFinishedQuest(ModQuests.ART_OF_WEATHER_TRIAL_03);
    }
}

