/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.baku;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.WorkbenchContainer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;

public class BakuFactoryAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "baku_factory", new Pair[]{ImmutablePair.of((Object)"Allows the user to craft items and blocks without the need for a Crafting Table.", null)});
    public static final AbilityCore<BakuFactoryAbility> INSTANCE = new AbilityCore.Builder<BakuFactoryAbility>("Baku Factory", AbilityCategory.DEVIL_FRUITS, BakuFactoryAbility::new).addDescriptionLine(DESCRIPTION).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(100, this::startContinuityEvent).addTickEvent(100, this::tickContinuityEvent);
    private BlockState previousBlock;

    public BakuFactoryAbility(AbilityCore<BakuFactoryAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            BlockPos pos = player.func_233580_cy_();
            this.previousBlock = player.field_70170_p.func_180495_p(pos);
            player.field_70170_p.func_175656_a(pos, Blocks.field_150462_ai.func_176223_P());
            player.func_213829_a(player.field_70170_p.func_180495_p(pos).func_215699_b(player.field_70170_p, pos));
            player.field_70170_p.func_175656_a(pos, this.previousBlock);
        }
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        Container container;
        if (!entity.field_70170_p.field_72995_K && entity instanceof PlayerEntity && !((container = ((ServerPlayerEntity)entity).field_71070_bA) instanceof WorkbenchContainer)) {
            this.continuousComponent.stopContinuity(entity);
        }
    }
}

