/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.baku;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.entities.projectiles.baku.BeroCannonProjectile;

public class BakuTsuihoAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "baku_tsuiho", new Pair[]{ImmutablePair.of((Object)"Allows the user to charge multiple blocks from their inventory in their mouth and shoot them all at the same time.", null)});
    private static final float CHARGE_TIME = 60.0f;
    private static final float COOLDOWN = 160.0f;
    public static final AbilityCore<BakuTsuihoAbility> INSTANCE = new AbilityCore.Builder<BakuTsuihoAbility>("Baku Tsuiho", AbilityCategory.DEVIL_FRUITS, BakuTsuihoAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(160.0f), ChargeComponent.getTooltip(60.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(SourceType.BLUNT).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(100, this::startContinuityEvent);
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addEndEvent(100, this::endChargeEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent(this).addTriggerEvent(100, this::triggerRepeaterEvent).addStopEvent(100, this::stopRepeaterEvent);
    private int ammo;

    public BakuTsuihoAbility(AbilityCore<BakuTsuihoAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.chargeComponent, this.projectileComponent, this.repeaterComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.stop(entity);
            return;
        }
        this.chargeComponent.startCharging(entity, 60.0f);
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.ammo = 0;
        List<ItemStack> availableBlocks = this.getBlocksInInventory(entity);
        for (int idx = 0; this.ammo < 20 && idx < availableBlocks.size(); ++idx) {
            ItemStack stack = availableBlocks.get(idx);
            ItemStack copy = stack.func_77946_l();
            this.ammo += copy.func_190916_E();
            stack.func_190918_g(this.ammo);
        }
        this.continuousComponent.startContinuity(entity, -1.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.repeaterComponent.start(entity, this.ammo, 3);
    }

    private void triggerRepeaterEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shootWithSpread(entity, 3.0f, 4.0f, 1);
    }

    private void stopRepeaterEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        this.cooldownComponent.startCooldown(entity, 160.0f);
    }

    private BeroCannonProjectile createProjectile(LivingEntity entity) {
        BeroCannonProjectile proj = new BeroCannonProjectile(entity.field_70170_p, entity, this);
        return proj;
    }

    private List<ItemStack> getBlocksInInventory(LivingEntity entity) {
        ArrayList<ItemStack> projectiles = new ArrayList<ItemStack>();
        for (ItemStack item : ItemsHelper.getInventoryItems(entity)) {
            if (item == null || !(item.func_77973_b() instanceof BlockItem) || DefaultProtectionRules.CORE_FOLIAGE_ORE.getApprovedBlocks().stream().anyMatch(p -> p == ((BlockItem)item.func_77973_b()).func_179223_d().getRegistryName())) continue;
            projectiles.add(item);
        }
        return projectiles;
    }
}

